/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIDTest
extends XMLObjectProviderBaseTestCase {
    private String expectedName;
    private String expectedNameQualifier;
    private String expectedSPNameQualifier;
    private String expectedFormat;
    private String expectedSPID;

    public NameIDTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/NameID.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/NameIDOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedName = "id name";
        this.expectedNameQualifier = "nq";
        this.expectedSPNameQualifier = "spnq";
        this.expectedFormat = "format style";
        this.expectedSPID = "spID";
    }

    @Test
    public void testSingleElementUnmarshall() {
        NameID nameID = (NameID)this.unmarshallElement(this.singleElementFile);
        String name = nameID.getValue();
        Assert.assertEquals((String)this.expectedName, (String)name, (String)"Name not as expected");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        NameID nameID = (NameID)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String name = nameID.getValue();
        Assert.assertEquals((String)this.expectedName, (String)name, (String)"Name not as expected");
        String nameQualifier = nameID.getNameQualifier();
        Assert.assertEquals((String)this.expectedNameQualifier, (String)nameQualifier, (String)"NameQualifier not as expected");
        String spNameQualifier = nameID.getSPNameQualifier();
        Assert.assertEquals((String)this.expectedSPNameQualifier, (String)spNameQualifier, (String)"SPNameQualifier not as expected");
        String format = nameID.getFormat();
        Assert.assertEquals((String)this.expectedFormat, (String)format, (String)"Format not as expected");
        String spProvidedID = nameID.getSPProvidedID();
        Assert.assertEquals((String)this.expectedSPID, (String)spProvidedID, (String)"SPProviderID not as expected");
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        NameID nameID = (NameID)this.buildXMLObject(qname);
        nameID.setValue(this.expectedName);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)nameID);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        NameID nameID = (NameID)this.buildXMLObject(qname);
        nameID.setValue(this.expectedName);
        nameID.setNameQualifier(this.expectedNameQualifier);
        nameID.setSPNameQualifier(this.expectedSPNameQualifier);
        nameID.setFormat(this.expectedFormat);
        nameID.setSPProvidedID(this.expectedSPID);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)nameID);
    }
}

