/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyInfoConfirmationDataTypeTest
extends XMLObjectProviderBaseTestCase {
    private DateTime expectedNotBefore;
    private DateTime expectedNotOnOrAfter;
    private String expectedRecipient;
    private String expectedInResponseTo;
    private String expectedAddress;
    private QName expectedType;
    private int expectedNumKeyInfoChildren;

    public KeyInfoConfirmationDataTypeTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/KeyInfoConfirmationDataType.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/KeyInfoConfirmationDataTypeOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/KeyInfoConfirmationDataTypeChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNotBefore = new DateTime(1984, 8, 26, 10, 1, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedNotOnOrAfter = new DateTime(1984, 8, 26, 10, 11, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedRecipient = "recipient";
        this.expectedInResponseTo = "inresponse";
        this.expectedAddress = "address";
        this.expectedType = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "KeyInfoConfirmationDataType", "saml2");
        this.expectedNumKeyInfoChildren = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyInfoConfirmationDataType kicd = (KeyInfoConfirmationDataType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)kicd, (String)"Object was null");
        Assert.assertEquals((Object)kicd.getSchemaType(), (Object)this.expectedType, (String)"Object xsi:type was not the expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        KeyInfoConfirmationDataType kicd = (KeyInfoConfirmationDataType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        DateTime notBefore = kicd.getNotBefore();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedNotBefore, (String)("NotBefore was " + notBefore + ", expected " + this.expectedNotBefore));
        DateTime notOnOrAfter = kicd.getNotOnOrAfter();
        Assert.assertEquals((Object)notOnOrAfter, (Object)this.expectedNotOnOrAfter, (String)("NotOnOrAfter was " + notOnOrAfter + ", expected " + this.expectedNotOnOrAfter));
        String recipient = kicd.getRecipient();
        Assert.assertEquals((String)recipient, (String)this.expectedRecipient, (String)("Recipient was " + recipient + ", expected " + this.expectedRecipient));
        String inResponseTo = kicd.getInResponseTo();
        Assert.assertEquals((String)inResponseTo, (String)this.expectedInResponseTo, (String)("InResponseTo was " + inResponseTo + ", expected " + this.expectedInResponseTo));
        String address = kicd.getAddress();
        Assert.assertEquals((String)address, (String)this.expectedAddress, (String)("Address was " + address + ", expected " + this.expectedAddress));
        Assert.assertEquals((Object)kicd.getSchemaType(), (Object)this.expectedType, (String)"Object xsi:type was not the expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyInfoConfirmationDataType kicd = (KeyInfoConfirmationDataType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)kicd.getKeyInfos().size(), (int)3, (String)"Unexpected number of KeyInfo children");
        Assert.assertEquals((int)kicd.getUnknownXMLObjects(KeyInfo.DEFAULT_ELEMENT_NAME).size(), (int)3, (String)"Unexpected number of KeyInfo children");
    }

    @Test
    public void testSingleElementMarshall() {
        KeyInfoConfirmationDataType kicd = this.buildXMLObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)kicd);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        KeyInfoConfirmationDataType kicd = this.buildXMLObject();
        kicd.setNotBefore(this.expectedNotBefore);
        kicd.setNotOnOrAfter(this.expectedNotOnOrAfter);
        kicd.setRecipient(this.expectedRecipient);
        kicd.setInResponseTo(this.expectedInResponseTo);
        kicd.setAddress(this.expectedAddress);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)kicd);
    }

    @Test
    public void testChildElementsMarshall() {
        KeyInfoConfirmationDataType kicd = this.buildXMLObject();
        for (int i = 0; i < this.expectedNumKeyInfoChildren; ++i) {
            KeyInfo keyinfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            kicd.getKeyInfos().add(keyinfo);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)kicd);
    }

    public KeyInfoConfirmationDataType buildXMLObject() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(KeyInfoConfirmationDataType.TYPE_NAME);
        if (builder == null) {
            Assert.fail((String)("Unable to retrieve builder for object QName " + KeyInfoConfirmationDataType.TYPE_NAME));
        }
        return (KeyInfoConfirmationDataType)builder.buildObject();
    }
}

