/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Action;
import org.opensaml.saml.saml2.core.AuthzDecisionQuery;
import org.opensaml.saml.saml2.core.Evidence;
import org.opensaml.saml.saml2.core.impl.SubjectQueryTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthzDecisionQueryTest
extends SubjectQueryTestBase {
    private String expectedResource;
    private int expectedNumActions;

    public AuthzDecisionQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionQueryOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionQueryChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedResource = "urn:string:resource";
        this.expectedNumActions = 2;
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthzDecisionQuery", "saml2p");
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        query.setResource(this.expectedResource);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)query);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthzDecisionQuery", "saml2p");
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        super.populateOptionalAttributes((SAMLObject)query);
        query.setResource(this.expectedResource);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)query);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthzDecisionQuery", "saml2p");
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)query);
        QName actionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Action", "saml2");
        for (int i = 0; i < this.expectedNumActions; ++i) {
            query.getActions().add((Action)this.buildXMLObject(actionQName));
        }
        QName evidenceQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Evidence", "saml2");
        query.setEvidence((Evidence)this.buildXMLObject(evidenceQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)query);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)query, (String)"AuthzDecisionQuery was null");
        Assert.assertEquals((String)query.getResource(), (String)this.expectedResource, (String)"Unmarshalled Resource attribute was not the expected value");
        super.helperTestSingleElementUnmarshall((SAMLObject)query);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)query);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthzDecisionQuery query = (AuthzDecisionQuery)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)query.getActions().size(), (int)this.expectedNumActions, (String)"Action count");
        Assert.assertNotNull((Object)query.getEvidence(), (String)"Evidence was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)query);
    }
}

