/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnStatementTest
extends XMLObjectProviderBaseTestCase {
    private DateTime expectedAuthnInstant;
    private String expectedSessionIndex;
    private DateTime expectedSessionNotOnOrAfter;

    public AuthnStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthnStatement.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AuthnStatementOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthnStatementChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAuthnInstant = new DateTime(1984, 8, 26, 10, 1, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedSessionIndex = "index";
        this.expectedSessionNotOnOrAfter = new DateTime(1984, 8, 26, 10, 11, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.unmarshallElement(this.singleElementFile);
        DateTime authnInstant = authnStatement.getAuthnInstant();
        Assert.assertEquals((Object)authnInstant, (Object)this.expectedAuthnInstant, (String)("AuthnInstant was " + authnInstant + ", expected " + this.expectedAuthnInstant));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        DateTime authnInstant = authnStatement.getAuthnInstant();
        Assert.assertEquals((Object)authnInstant, (Object)this.expectedAuthnInstant, (String)("AuthnInstant was " + authnInstant + ", expected " + this.expectedAuthnInstant));
        String sessionIndex = authnStatement.getSessionIndex();
        Assert.assertEquals((String)sessionIndex, (String)this.expectedSessionIndex, (String)("SessionIndex was " + sessionIndex + ", expected " + this.expectedSessionIndex));
        DateTime sessionNotOnOrAfter = authnStatement.getSessionNotOnOrAfter();
        Assert.assertEquals((Object)sessionNotOnOrAfter, (Object)this.expectedSessionNotOnOrAfter, (String)("SessionNotOnOrAfter was " + sessionNotOnOrAfter + ", expected " + this.expectedSessionNotOnOrAfter));
    }

    @Test
    public void testSingleElementMarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnInstant(this.expectedAuthnInstant);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)authnStatement);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnInstant(this.expectedAuthnInstant);
        authnStatement.setSessionIndex(this.expectedSessionIndex);
        authnStatement.setSessionNotOnOrAfter(this.expectedSessionNotOnOrAfter);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authnStatement);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authnStatement.getAuthnContext(), (String)"AuthnContext element not present");
        Assert.assertNotNull((Object)authnStatement.getSubjectLocality(), (String)"SubjectLocality element not present");
    }

    @Test
    public void testChildElementsMarshall() {
        AuthnStatement authnStatement = (AuthnStatement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setSubjectLocality((SubjectLocality)this.buildXMLObject(SubjectLocality.DEFAULT_ELEMENT_NAME));
        authnStatement.setAuthnContext((AuthnContext)this.buildXMLObject(AuthnContext.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authnStatement);
    }
}

