/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnRequestTest
extends RequestTestBase {
    private XSBooleanValue expectedForceAuthn;
    private XSBooleanValue expectedIsPassive;
    private String expectedProtocolBinding;
    private Integer expectedAssertionConsumerServiceIndex;
    private String expectedAssertionConsumerServiceURL;
    private Integer expectedAttributeConsumingServiceIndex;
    private String expectedProviderName;

    public AuthnRequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthnRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AuthnRequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthnRequestChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedForceAuthn = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedIsPassive = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedProtocolBinding = "urn:string:protocol-binding";
        this.expectedAssertionConsumerServiceIndex = new Integer(3);
        this.expectedAssertionConsumerServiceURL = "http://sp.example.org/acs";
        this.expectedAttributeConsumingServiceIndex = new Integer(2);
        this.expectedProviderName = "Example Org";
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "saml2p");
        AuthnRequest req = (AuthnRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "saml2p");
        AuthnRequest req = (AuthnRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        super.populateOptionalAttributes((SAMLObject)req);
        req.setForceAuthn(this.expectedForceAuthn);
        req.setIsPassive(this.expectedIsPassive);
        req.setProtocolBinding(this.expectedProtocolBinding);
        req.setAssertionConsumerServiceIndex(this.expectedAssertionConsumerServiceIndex);
        req.setAssertionConsumerServiceURL(this.expectedAssertionConsumerServiceURL);
        req.setAttributeConsumingServiceIndex(this.expectedAttributeConsumingServiceIndex);
        req.setProviderName(this.expectedProviderName);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)req);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "saml2p");
        AuthnRequest req = (AuthnRequest)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)req);
        QName subjectQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject", "saml2");
        req.setSubject((Subject)this.buildXMLObject(subjectQName));
        QName nameIDPolicyQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDPolicy", "saml2p");
        req.setNameIDPolicy((NameIDPolicy)this.buildXMLObject(nameIDPolicyQName));
        QName conditionsQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions", "saml2");
        req.setConditions((Conditions)this.buildXMLObject(conditionsQName));
        QName requestedAuthnContextQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "RequestedAuthnContext", "saml2p");
        req.setRequestedAuthnContext((RequestedAuthnContext)this.buildXMLObject(requestedAuthnContextQName));
        QName scopingQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Scoping", "saml2p");
        req.setScoping((Scoping)this.buildXMLObject(scopingQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        AuthnRequest req = (AuthnRequest)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)req, (String)"AuthnRequest was null");
        Assert.assertEquals((Object)req.isForceAuthn(), (Object)Boolean.FALSE, (String)"ForceAuthn (empty) was not default value");
        Assert.assertEquals((Object)req.isPassive(), (Object)Boolean.FALSE, (String)"IsPassive (empty) was not default value");
        Assert.assertNull((Object)req.getProtocolBinding(), (String)"ProtocolBinding was not null");
        Assert.assertNull((Object)req.getAssertionConsumerServiceIndex(), (String)"AssertionConsumerServiceIndex was not null");
        Assert.assertNull((Object)req.getAssertionConsumerServiceURL(), (String)"AssertionConsumerServiceURL was not null");
        Assert.assertNull((Object)req.getAttributeConsumingServiceIndex(), (String)"AttributeConsumingServiceIndex was not null");
        Assert.assertNull((Object)req.getProviderName(), (String)"ProviderName was not null");
        super.helperTestSingleElementUnmarshall((SAMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthnRequest req = (AuthnRequest)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((Object)req.isForceAuthnXSBoolean(), (Object)this.expectedForceAuthn, (String)"Unmarshalled ForceAuthn was not the expected value");
        Assert.assertEquals((Object)req.isPassiveXSBoolean(), (Object)this.expectedIsPassive, (String)"Unmarshalled IsPassive was not the expected value");
        Assert.assertEquals((String)req.getProtocolBinding(), (String)this.expectedProtocolBinding, (String)"Unmarshalled ProtocolBinding was not the expected value");
        Assert.assertEquals((Object)req.getAssertionConsumerServiceIndex(), (Object)this.expectedAssertionConsumerServiceIndex, (String)"Unmarshalled AssertionConsumerServiceIndex was not the expected value");
        Assert.assertEquals((String)req.getAssertionConsumerServiceURL(), (String)this.expectedAssertionConsumerServiceURL, (String)"Unmarshalled AssertionConsumerServiceURL was not the expected value");
        Assert.assertEquals((Object)req.getAttributeConsumingServiceIndex(), (Object)this.expectedAttributeConsumingServiceIndex, (String)"Unmarshalled AttributeConsumingServiceIndex was not the expected value");
        Assert.assertEquals((String)req.getProviderName(), (String)this.expectedProviderName, (String)"Unmarshalled ProviderName was not the expected value");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)req);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthnRequest req = (AuthnRequest)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)req.getSubject(), (String)"Subject was null");
        Assert.assertNotNull((Object)req.getNameIDPolicy(), (String)"NameIDPolicy was null");
        Assert.assertNotNull((Object)req.getConditions(), (String)"Conditions was null");
        Assert.assertNotNull((Object)req.getRequestedAuthnContext(), (String)"RequestedAuthnContext was null");
        Assert.assertNotNull((Object)req.getScoping(), (String)"Scoping was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)req);
    }

    @Test
    public void testXSBooleanAttributes() {
        AuthnRequest req = (AuthnRequest)this.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        req.setForceAuthn(Boolean.TRUE);
        Assert.assertEquals((Object)req.isForceAuthn(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)req.isForceAuthnXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)req.isForceAuthnXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)req.isForceAuthnXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        req.setForceAuthn(Boolean.FALSE);
        Assert.assertEquals((Object)req.isForceAuthn(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)req.isForceAuthnXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)req.isForceAuthnXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)req.isForceAuthnXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        req.setForceAuthn((Boolean)null);
        Assert.assertEquals((Object)req.isForceAuthn(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)req.isForceAuthnXSBoolean(), (String)"XSBooleanValue was not null");
        req.setIsPassive(Boolean.TRUE);
        Assert.assertEquals((Object)req.isPassive(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)req.isPassiveXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)req.isPassiveXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)req.isPassiveXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        req.setIsPassive(Boolean.FALSE);
        Assert.assertEquals((Object)req.isPassive(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)req.isPassiveXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)req.isPassiveXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)req.isPassiveXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        req.setIsPassive((Boolean)null);
        Assert.assertEquals((Object)req.isPassive(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)req.isPassiveXSBoolean(), (String)"XSBooleanValue was not null");
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testBadSAMLVersion() throws XMLParserException, UnmarshallingException {
        this.unmarshallElement("/org/opensaml/saml/saml2/core/impl/AuthnRequestBadSAMLVersion.xml", true);
    }
}

