/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedName;
    protected String expectedNameFormat;
    protected String expectedFriendlyName;

    public AttributeTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Attribute.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AttributeOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedName = "attribName";
        this.expectedNameFormat = "urn:string";
        this.expectedFriendlyName = "Attribute Name";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Attribute attribute = (Attribute)this.unmarshallElement(this.singleElementFile);
        String name = attribute.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name was " + name + ", expected " + this.expectedName));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Attribute attribute = (Attribute)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String name = attribute.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name was " + name + ", expected " + this.expectedName));
        String nameFormat = attribute.getNameFormat();
        Assert.assertEquals((String)nameFormat, (String)this.expectedNameFormat, (String)("NameFormat was " + nameFormat + ", expected " + this.expectedNameFormat));
        String friendlyName = attribute.getFriendlyName();
        Assert.assertEquals((String)friendlyName, (String)this.expectedFriendlyName, (String)("FriendlyName was " + friendlyName + ", expected " + this.expectedFriendlyName));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute", "saml2");
        Attribute attribute = (Attribute)this.buildXMLObject(qname);
        attribute.setName(this.expectedName);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attribute);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute", "saml2");
        Attribute attribute = (Attribute)this.buildXMLObject(qname);
        attribute.setName(this.expectedName);
        attribute.setNameFormat(this.expectedNameFormat);
        attribute.setFriendlyName(this.expectedFriendlyName);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attribute);
    }
}

