/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.Action;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ActionTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedAction;
    protected String expectedNamespace;

    public ActionTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Action.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ActionOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAction = "action name";
        this.expectedNamespace = "ns";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Action action = (Action)this.unmarshallElement(this.singleElementFile);
        String actionname = action.getAction();
        Assert.assertEquals((String)actionname, (String)this.expectedAction, (String)("Action was " + actionname + ", expected " + this.expectedAction));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Action action = (Action)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String actionname = action.getAction();
        Assert.assertEquals((String)actionname, (String)this.expectedAction, (String)("Action was " + actionname + ", expected " + this.expectedAction));
        String namespace = action.getNamespace();
        Assert.assertEquals((String)namespace, (String)this.expectedNamespace, (String)("Namespace was " + namespace + ", expected " + this.expectedNamespace));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Action", "saml2");
        Action action = (Action)this.buildXMLObject(qname);
        action.setAction(this.expectedAction);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)action);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Action", "saml2");
        Action action = (Action)this.buildXMLObject(qname);
        action.setAction(this.expectedAction);
        action.setNamespace(this.expectedNamespace);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)action);
    }
}

