/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.BaseComplexSAMLObjectTestCase;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResponseSuccessAuthnAttribTest
extends BaseComplexSAMLObjectTestCase {
    public ResponseSuccessAuthnAttribTest() {
        this.elementFile = "/org/opensaml/saml/saml2/core/ResponseSuccessAuthnAttrib.xml";
    }

    @Override
    @Test
    public void testUnmarshall() {
        Response response = (Response)this.unmarshallElement(this.elementFile);
        Assert.assertNotNull((Object)response, (String)"Response was null");
        Assert.assertEquals((String)response.getID(), (String)"_c7055387-af61-4fce-8b98-e2927324b306", (String)"Response ID");
        Assert.assertEquals((String)response.getInResponseTo(), (String)"_abcdef123456", (String)"InResponseTo");
        Assert.assertEquals((String)response.getVersion().toString(), (String)SAMLVersion.VERSION_20.toString(), (String)"Version");
        Assert.assertEquals((Object)response.getIssueInstant(), (Object)new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()), (String)"IssueInstant");
        Assert.assertEquals((String)response.getIssuer().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", (String)"Issuer/@Format");
        Assert.assertEquals((String)response.getStatus().getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Success", (String)"Status/Statuscode/@Value");
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertNotNull((Object)assertion, (String)"Assertion[0] was null");
        Assert.assertEquals((String)assertion.getID(), (String)"_a75adf55-01d7-40cc-929f-dbd8372ebdfc", (String)"Assertion ID");
        Assert.assertEquals((Object)assertion.getIssueInstant(), (Object)new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()), (String)"Assertion/@IssueInstant");
        Assert.assertEquals((String)assertion.getVersion().toString(), (String)SAMLVersion.VERSION_20.toString(), (String)"Assertion/@Version");
        Assert.assertEquals((String)assertion.getIssuer().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", (String)"Assertion/Issuer/@Format");
        Assert.assertEquals((String)assertion.getSubject().getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (String)"Assertion/Subject/NameID/@Format");
        Assert.assertEquals((String)assertion.getSubject().getNameID().getValue(), (String)"_820d2843-2342-8236-ad28-8ac94fb3e6a1", (String)"Assertion/Subject/NameID contents");
        SubjectConfirmation sc = (SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0);
        Assert.assertEquals((String)sc.getMethod(), (String)"urn:oasis:names:tc:SAML:2.0:cm:bearer", (String)"Assertion/Subject/SubjectConfirmation/@Method");
        Assert.assertEquals((Object)assertion.getConditions().getNotBefore(), (Object)new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()), (String)"Assertion/Condition/@NotBefore");
        Assert.assertEquals((Object)assertion.getConditions().getNotOnOrAfter(), (Object)new DateTime(2006, 1, 26, 13, 45, 5, 0, (Chronology)ISOChronology.getInstanceUTC()), (String)"Assertion/Condition/@NotOnOrAfter");
        Audience audience = (Audience)((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0);
        Assert.assertEquals((String)audience.getAudienceURI(), (String)"https://sp.example.org", (String)"Assertion/Conditions/AudienceRestriction/Audience contents");
        AuthnStatement authnStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        Assert.assertEquals((Object)authnStatement.getAuthnInstant(), (Object)new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()), (String)"Assertion/AuthnStatement/@AuthnInstant");
        Assert.assertEquals((String)authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport", (String)"Assertion/AuthnStatement/AuthnContext/AuthnContextClassRef contents");
        AttributeStatement attribStatement = (AttributeStatement)assertion.getAttributeStatements().get(0);
        Attribute attrib = null;
        XSString value = null;
        attrib = (Attribute)attribStatement.getAttributes().get(0);
        Assert.assertEquals((String)attrib.getFriendlyName(), (String)"fooAttrib", (String)"Attribute/@FriendlyName");
        Assert.assertEquals((String)attrib.getName(), (String)"urn:foo:attrib", (String)"Attribute/@Name");
        Assert.assertEquals((String)attrib.getNameFormat(), (String)"urn:oasis:names:tc:SAML:2.0:attrname-format:uri", (String)"Attribute/@NameFormat");
        Assert.assertEquals((int)attrib.getAttributeValues().size(), (int)2, (String)"Number of fooAttrib AttributeValues");
        value = (XSString)attrib.getAttributeValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)"SomeValue", (String)"Attribute content");
        value = (XSString)attrib.getAttributeValues().get(1);
        Assert.assertEquals((String)value.getValue(), (String)"SomeOtherValue", (String)"Attribute content");
        attrib = (Attribute)attribStatement.getAttributes().get(1);
        Assert.assertEquals((String)attrib.getFriendlyName(), (String)"eduPersonPrincipalName", (String)"Attribute/@FriendlyName");
        Assert.assertEquals((String)attrib.getName(), (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.6", (String)"Attribute/@Name");
        Assert.assertEquals((String)attrib.getNameFormat(), (String)"urn:oasis:names:tc:SAML:2.0:attrname-format:uri", (String)"Attribute/@NameFormat");
        Assert.assertEquals((int)attrib.getAttributeValues().size(), (int)1, (String)"Number of ldapAttrib AttributeValues");
        value = (XSString)attrib.getAttributeValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)"j.doe@idp.example.org", (String)"Attribute content");
    }

    @Override
    @Test
    public void testMarshall() {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setID("_c7055387-af61-4fce-8b98-e2927324b306");
        response.setInResponseTo("_abcdef123456");
        response.setIssueInstant(new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()));
        Issuer rIssuer = (Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        rIssuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        rIssuer.setValue("https://idp.example.org");
        Status status = (Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)this.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        Assertion assertion = (Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID("_a75adf55-01d7-40cc-929f-dbd8372ebdfc");
        assertion.setIssueInstant(new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()));
        Issuer aIssuer = (Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        aIssuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        aIssuer.setValue("https://idp.example.org");
        Subject subject = (Subject)this.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        NameID nameID = (NameID)this.buildXMLObject(NameID.DEFAULT_ELEMENT_NAME);
        nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameID.setValue("_820d2843-2342-8236-ad28-8ac94fb3e6a1");
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        Conditions conditions = (Conditions)this.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()));
        conditions.setNotOnOrAfter(new DateTime(2006, 1, 26, 13, 45, 5, 0, (Chronology)ISOChronology.getInstanceUTC()));
        AudienceRestriction audienceRestriction = (AudienceRestriction)this.buildXMLObject(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        Audience audience = (Audience)this.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
        audience.setAudienceURI("https://sp.example.org");
        AuthnStatement authnStatement = (AuthnStatement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnInstant(new DateTime(2006, 1, 26, 13, 35, 5, 0, (Chronology)ISOChronology.getInstanceUTC()));
        AuthnContext authnContext = (AuthnContext)this.buildXMLObject(AuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef classRef = (AuthnContextClassRef)this.buildXMLObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        classRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        AttributeStatement attribStatement = (AttributeStatement)this.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder stringBuilder = builderFactory.getBuilder(XSString.TYPE_NAME);
        Attribute fooAttrib = (Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        fooAttrib.setFriendlyName("fooAttrib");
        fooAttrib.setName("urn:foo:attrib");
        fooAttrib.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        XSString fooAttribValue = null;
        fooAttribValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        fooAttribValue.setValue("SomeValue");
        fooAttrib.getAttributeValues().add(fooAttribValue);
        fooAttribValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        fooAttribValue.setValue("SomeOtherValue");
        fooAttrib.getAttributeValues().add(fooAttribValue);
        Attribute ldapAttrib = (Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        ldapAttrib.setFriendlyName("eduPersonPrincipalName");
        ldapAttrib.setName("urn:oid:1.3.6.1.4.1.5923.1.1.1.6");
        ldapAttrib.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        XSString ldapAttribValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        ldapAttribValue.setValue("j.doe@idp.example.org");
        ldapAttrib.getAttributeValues().add(ldapAttribValue);
        response.setIssuer(rIssuer);
        status.setStatusCode(statusCode);
        response.setStatus(status);
        response.getAssertions().add(assertion);
        assertion.setIssuer(aIssuer);
        subject.setNameID(nameID);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        assertion.setSubject(subject);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        assertion.setConditions(conditions);
        authnContext.setAuthnContextClassRef(classRef);
        authnStatement.setAuthnContext(authnContext);
        assertion.getAuthnStatements().add(authnStatement);
        attribStatement.getAttributes().add(fooAttrib);
        attribStatement.getAttributes().add(ldapAttrib);
        assertion.getAttributeStatements().add(attribStatement);
        this.assertXMLEquals("Marshalled Response was not the expected value", this.expectedDOM, (XMLObject)response);
    }
}

