/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import java.net.MalformedURLException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLTestSupport;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAML2HTTPRedirectDeflateSignatureSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext<SAMLObject> messageContext;
    private SAML2HTTPRedirectDeflateSignatureSecurityHandler handler;
    private X509Certificate signingCert = X509Support.decodeCertificate((String)this.signingCertBase64);
    private String signingCertBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";
    private PrivateKey signingPrivateKey = KeySupport.buildJavaRSAPrivateKey((String)this.signingPrivateKeyBase64);
    private String signingPrivateKeyBase64 = "MIIEogIBAAKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQABAoIBAC1P4lZvHBiqGll66G8pXGS0bXA4Ya9DyTk0UgFU9GKRlSAYWy18Gc9rDNAETD6Uklfxgae9CL0s+D1ovuxDDh3DuwO26sv/oO06Vmyx87GMcThshuOQeSSCeuwOIHyDdvfTqZrmPY/d3KIQn6aNEcBBj7fL5cJncIe20nJGPkB9KuTAaGVnaKoOesxgWBr7SvjGq/SB7bRE1B3cQxwUDWHkF0LljSIkXaV9ehKJcgBY2fV0rc8pI53WsUXEXk5HoqYZnQ5QjAZ4Hf2sbRKevq+D2ENK+OuKNuCAS/oJbGSdS7q0/6jgHZ6cUGXi1r2qEEG7PIorCoSMkWQSM1wMX0ECgYEA9c6/s9lKDrjzyjO9rlxzufGVRDjffiUZ1o8F3RD3JltdPLVcd429CvGSNV730Yr/wSyRAum4vkGnmOR9tuQdi3PJHt3xGRsymTT5ym/5fnC4SvXVSR6vLFPUY80yj+D6/0lwIaGE7x4JOclMXnHjqcpRl14onOjY844WORhxgjkCgYEA1d5NTqp938UbZYKX4Q9UvLf/pVR9xOFOCYnMywAFk0WnkUBPHmPoJuFgeNGeQ7gCmHi7JFzwBjkj6DcGMdbXKWiUij1BoRxf9Mof+fZBWVSKw+/yVLbJkyK951+nywyiq3HCNBti1eK/h/hXQd8t+dCBmDGj1ba1C2/3JZqLg7kCgYArxD1D85uJFYtq5F2Qryt33zj5pbq9hjOcjWi43O10qe3nAk/NhbI0QaEL2bX8XGh/Z8UGJMFdNul1grGTn/hWvS4BTflAxCP1PYaAcgGVbtKRnkX0t/7uwJpfjsjC74chb10Ez/KQdOOlo17yrgqgT8LJVd2bWqZOb20ri1uimQKBgFfJYSg6OWLh0IYRXfBmz5yLVmdx0BJBfTvTEXn+L0utWsP3hsJttfxHpMbTHEilvoMBg6fAclHLoJ6P/33ztuvrXpWD4W2VbRnY4dlDqL1XQ4J7+pelVAaOSy8vB3wEWr1O+61R1HcBFSdl28NRLdkOKjPjpGF0Fsp0EhmgX0YZAoGAXrM4+BUvcx2PLaeneTJoRdOi3GQbdAte03maDU6C474IdgR8IUygfspv3fiGue9Wmk5ybUBlv/D6sIWVhnnedWsg2zAgZPfZ78HLLNhWeEx33wPFiK0wV5MJXQ224gQ5t9D3WXdZtmAxXIFoopj4zToCMBjXyep0u7zl3s7s00U=";
    private X509Certificate otherCert1;
    private String otherCert1Base64 = "MIIECTCCAvGgAwIBAgIBMzANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMTYxMVoXDTE3MDUyMjIwMTYxMVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIIBtjCCASsGByqGSM44BAEwggEeAoGBAI+ktw7R9m7TxjaCrT2MHwWNQUAyXPrqbFCcu+DCirr861U6R6W/GyqWdcy8/D1Hh/I1U94POQn5yfqVPpVH2ZRS4OMFndHWaoo9V5LJoXTXHiDYB3W4t9tn0fm7It0n7VoUI5C4y9LG32Hq+UIGF/ktNTmo//mEqLS6aJNdbMFpAhUArmKGh0hcpmjukYArWcMRvipB4CMCgYBuCiCrUaHBRRtqrk0P/Luq0l2M2718GwSGeLPZip06gACDG7IctMrgH1J+ZIjsx6vffi977wnMDiktqacmaobV+SCRW9ijJRdkYpUHmlLvuJGnDPjkvewpbGWJsCabpWEvWdYw3ma8RuHOPj4Jkrdd4VcRaFwox/fPJ7cG6kBydgOBhAACgYBxQIPv9DCsmiMHG1FAxSARX0GcRiELJPJ+MtaStdTrVobNa2jebwc3npLiTvUR4U/CDo1mSZb+Sp/wian8kNZHmGcR6KbtJs9UDsa3V0pbbgpUar4HcxV+NQJBbhn9RGu85g3PDILUrINiUAf26mhPN5Y0paM+HbM68nUf1OLv16OBsjCBrzAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUIHFAEB/3jIIZzJEJ/qdsuI8vN3kwVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBAJt4Q34+pqjW5tHHhkdzTITSBjOOf8EvYMgxTMRzhagLSHTt9RgO5i/G7ELvnwe1j6187m1XD9iEAWKeKbB//ljeOpgnwzkLR9Er5tr1RI3cbil0AX+oX0c1jfRaQnR50Rfb5YoNX6G963iphlxp9C8VLB6eOk/S270XoWoQIkO1ioQ8JY4HE6AyDsOpJaOmHpBaxjgsiko52ZWZeZyaCyL98BXwVxeml7pYnHlXWWidB0N/Zy+LbvWg3urUkiDjMcB6nGImmEfDSxRdybitcMwbwL26z2WOpwL3llm3mcCydKXgXt8IQhfDhOZOHWckeD2tStnJRP/cqBgO62/qirw=";
    private CollectionCredentialResolver credResolver;
    private List<Credential> trustedCredentials;
    private BasicX509Credential signingX509Cred = new BasicX509Credential(this.signingCert, this.signingPrivateKey);
    private BasicX509Credential otherCred1;
    private String issuer = "SomeCoolIssuer";
    private String expectedRelayValue = "cookieMonster";
    private SignatureTrustEngine signatureTrustEngine;
    private SignatureValidationParameters sigValParams;

    public SAML2HTTPRedirectDeflateSignatureSecurityHandlerTest() throws CertificateException, KeyException {
        this.signingX509Cred.setEntityId(this.issuer);
        this.otherCert1 = X509Support.decodeCertificate((String)this.otherCert1Base64);
        this.otherCred1 = new BasicX509Credential(this.otherCert1);
        this.otherCred1.setEntityCertificate(this.otherCert1);
        this.otherCred1.setEntityId("other-1");
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.trustedCredentials = new ArrayList<Credential>();
        this.trustedCredentials.add((Credential)this.otherCred1);
        this.credResolver = new CollectionCredentialResolver(this.trustedCredentials);
        KeyInfoCredentialResolver kiResolver = SAMLTestSupport.buildBasicInlineKeyInfoResolver();
        this.signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this.credResolver, kiResolver);
        this.sigValParams = new SignatureValidationParameters();
        this.sigValParams.setSignatureTrustEngine(this.signatureTrustEngine);
        this.handler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
        this.handler.setHttpServletRequest((HttpServletRequest)this.buildServletRequest());
        this.handler.initialize();
        this.messageContext = new MessageContext();
        this.messageContext.setMessage((Object)this.buildInboundSAMLMessage());
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(this.issuer);
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ((SecurityParametersContext)this.messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureValidationParameters(this.sigValParams);
    }

    @Test
    public void testSuccess() throws MessageHandlerException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        this.handler.invoke(this.messageContext);
        Assert.assertEquals((String)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getEntityId(), (String)this.issuer, (String)"Unexpected value for Issuer found");
        Assert.assertTrue((boolean)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).isAuthenticated(), (String)"Unexpected value for context authentication state");
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testBlacklistedSignatureAlgorithm() throws MessageHandlerException {
        this.sigValParams.setBlacklistedAlgorithms(Collections.singleton("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testUntrustedCredential() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidSignature() throws MessageHandlerException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        MockHttpServletRequest request = (MockHttpServletRequest)this.handler.getHttpServletRequest();
        String queryString = request.getQueryString();
        request.setQueryString(queryString.replaceFirst("RelayState=", "RelayState=AlteredData"));
        request.setParameter("RelayState", "AlteredData" + request.getParameter("RelayState"));
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoContextIssuer() throws MessageHandlerException {
        this.messageContext.removeSubcontext(SAMLPeerEntityContext.class);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoTrustEngine() throws MessageHandlerException {
        this.messageContext.removeSubcontext(SecurityParametersContext.class);
        this.handler.invoke(this.messageContext);
    }

    protected AuthnRequest buildInboundSAMLMessage() {
        return (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
    }

    protected MockHttpServletRequest buildServletRequest() {
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildInboundSAMLMessage());
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)this.expectedRelayValue);
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential((Credential)this.signingX509Cred);
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        try {
            encoder.initialize();
        }
        catch (ComponentInitializationException e1) {
            Assert.fail((String)"Failed to initialize encoder");
        }
        try {
            encoder.prepareContext();
            encoder.encode();
        }
        catch (MessageEncodingException e) {
            Assert.fail((String)"Could not encode outbound message context");
        }
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(response.getRedirectedUrl());
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Could not parse redirect url: " + response.getRedirectedUrl()));
        }
        request.setQueryString(urlBuilder.buildQueryString());
        for (Pair param : urlBuilder.getQueryParams()) {
            request.setParameter((String)param.getFirst(), (String)param.getSecond());
        }
        return request;
    }
}

