/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.binding.impl.ExtractProxiedRequestersHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExtractProxiedRequestersHandlerTest
extends OpenSAMLInitBaseTestCase {
    SAMLObjectBuilder<Scoping> scopingBuilder;
    SAMLObjectBuilder<RequesterID> requesterIDBuilder;

    @BeforeClass
    public void setUp() {
        this.scopingBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Scoping.DEFAULT_ELEMENT_NAME);
        this.requesterIDBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(RequesterID.DEFAULT_ELEMENT_NAME);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingRequest() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        ExtractProxiedRequestersHandler handler = new ExtractProxiedRequestersHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        Scoping scoping = (Scoping)this.scopingBuilder.buildObject();
        RequesterID one = (RequesterID)this.requesterIDBuilder.buildObject();
        one.setRequesterID("one");
        RequesterID two = (RequesterID)this.requesterIDBuilder.buildObject();
        two.setRequesterID("two");
        scoping.getRequesterIDs().addAll(Arrays.asList(one, two));
        ((AuthnRequest)messageCtx.getMessage()).setScoping(scoping);
        ExtractProxiedRequestersHandler handler = new ExtractProxiedRequestersHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        ProxiedRequesterContext ctx = (ProxiedRequesterContext)messageCtx.getSubcontext(ProxiedRequesterContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((int)ctx.getRequesters().size(), (int)2);
        Assert.assertTrue((boolean)ctx.getRequesters().contains("one"));
        Assert.assertTrue((boolean)ctx.getRequesters().contains("two"));
        Assert.assertFalse((boolean)ctx.getRequesters().contains("foo"));
    }
}

