/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.ECPContext;
import org.opensaml.saml.ext.samlec.GeneratedKey;
import org.opensaml.saml.saml2.binding.impl.AddGeneratedKeyHeaderHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddGeneratedKeyHeaderHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageCtx;
    private AddGeneratedKeyHeaderHandler handler;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.messageCtx = new MessageContext();
        this.handler = new AddGeneratedKeyHeaderHandler();
        this.handler.initialize();
    }

    @Test
    public void testUnauthenticated() throws MessageHandlerException {
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)GeneratedKey.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
        this.messageCtx.getSubcontext(ECPContext.class, true);
        this.handler.invoke(this.messageCtx);
        headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)GeneratedKey.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingEnvelope() throws MessageHandlerException, NoSuchAlgorithmException {
        ((ECPContext)this.messageCtx.getSubcontext(ECPContext.class, true)).setSessionKey(SecureRandom.getInstance("SHA1prng").generateSeed(16));
        this.handler.invoke(this.messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, NoSuchAlgorithmException {
        byte[] key = new byte[32];
        SecureRandom.getInstance("SHA1prng").nextBytes(key);
        ((ECPContext)this.messageCtx.getSubcontext(ECPContext.class, true)).setSessionKey(key);
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        ((SOAP11Context)this.messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)GeneratedKey.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((String)((XSBase64Binary)headers.get(0)).getValue(), (String)Base64Support.encode((byte[])key, (boolean)false));
    }
}

