/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.impl.AddECPResponseHeaderHandler;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddECPResponseHeaderHandlerTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testMissingEndpointContext() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        AddECPResponseHeaderHandler handler = new AddECPResponseHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)messageCtx, (QName)Response.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingEnvelope() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        Endpoint ep = (Endpoint)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AssertionConsumerService.DEFAULT_ELEMENT_NAME).buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        ep.setLocation("foo");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageCtx.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(ep);
        AddECPResponseHeaderHandler handler = new AddECPResponseHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        ((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        Endpoint ep = (Endpoint)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AssertionConsumerService.DEFAULT_ELEMENT_NAME).buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        ep.setLocation("foo");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageCtx.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(ep);
        AddECPResponseHeaderHandler handler = new AddECPResponseHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)messageCtx, (QName)Response.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((String)((Response)headers.get(0)).getAssertionConsumerServiceURL(), (String)"foo");
    }
}

