/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLConsentContext;
import org.opensaml.saml.saml2.binding.impl.AddConsentToResponseHandler;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddConsentToResponseHandlerTest
extends OpenSAMLInitBaseTestCase {
    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingContext() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        AddConsentToResponseHandler handler = new AddConsentToResponseHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        ((SAMLConsentContext)messageCtx.getSubcontext(SAMLConsentContext.class, true)).setConsent("urn:oasis:names:tc:SAML:2.0:consent:current-explicit");
        AddConsentToResponseHandler handler = new AddConsentToResponseHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        Assert.assertEquals((String)((StatusResponseType)messageCtx.getMessage()).getConsent(), (String)"urn:oasis:names:tc:SAML:2.0:consent:current-explicit");
    }
}

