/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class HTTPRedirectDeflateEncoderTest
extends XMLObjectBaseTestCase {
    @Test
    public void testResponseEncoding() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        URLBuilder urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        Map queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertFalse((boolean)queryParams.containsKey("Signature"));
        Assert.assertFalse((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
    }

    @Test
    public void testResponseEncodingWithEndpointQueryParams() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response?foo=bar&abc=123");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        URLBuilder urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        Map queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertTrue((boolean)queryParams.containsKey("foo"));
        Assert.assertEquals((String)((String)queryParams.get("foo")), (String)"bar");
        Assert.assertTrue((boolean)queryParams.containsKey("abc"));
        Assert.assertEquals((String)((String)queryParams.get("abc")), (String)"123");
        Assert.assertFalse((boolean)queryParams.containsKey("Signature"));
        Assert.assertFalse((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
    }

    @Test
    public void testResponseEncodingWithDisallowedEndpointQueryParams() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response?foo=bar&abc=123&SAMLEncoding=blah&SAMLRequest=blah&SAMLResponse=blah&RelayState=blah&SigAlg=blah&Signature=blah");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        URLBuilder urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        Map queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertTrue((boolean)queryParams.containsKey("foo"));
        Assert.assertEquals((String)((String)queryParams.get("foo")), (String)"bar");
        Assert.assertTrue((boolean)queryParams.containsKey("abc"));
        Assert.assertEquals((String)((String)queryParams.get("abc")), (String)"123");
        Assert.assertFalse((boolean)queryParams.containsKey("SAMLEncoding"));
        Assert.assertFalse((boolean)queryParams.containsKey("SAMLRequest"));
        Assert.assertFalse((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertFalse((boolean)queryParams.containsKey("Signature"));
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        Assert.assertNotEquals(queryParams.get("SAMLResponse"), (Object)"blah");
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
    }

    @Test
    public void testResponseEncodingWithSimpleSign() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate()));
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        URLBuilder urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        Map queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertTrue((boolean)queryParams.containsKey("Signature"));
        Assert.assertNotNull(queryParams.get("Signature"));
        Assert.assertTrue((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertEquals((String)((String)queryParams.get("SigAlg")), (String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
    }

    @Test
    public void OSJ271() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate()));
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        URLBuilder urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        Map queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertTrue((boolean)queryParams.containsKey("Signature"));
        Assert.assertNotNull(queryParams.get("Signature"));
        Assert.assertTrue((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertEquals((String)((String)queryParams.get("SigAlg")), (String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
        String signatureWithoutParams = (String)queryParams.get("Signature");
        samlEndpoint.setResponseLocation("http://example.org/response?foo=bar&abc=123");
        messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
        response = new MockHttpServletResponse();
        encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        urlBuilder = new URLBuilder(response.getRedirectedUrl());
        Assert.assertEquals((String)urlBuilder.getScheme(), (String)"http");
        Assert.assertEquals((String)urlBuilder.getHost(), (String)"example.org");
        Assert.assertEquals((String)urlBuilder.getPath(), (String)"/response");
        queryParams = URISupport.buildQueryMap((List)urlBuilder.getQueryParams());
        Assert.assertTrue((boolean)queryParams.containsKey("foo"));
        Assert.assertEquals((String)((String)queryParams.get("foo")), (String)"bar");
        Assert.assertTrue((boolean)queryParams.containsKey("abc"));
        Assert.assertEquals((String)((String)queryParams.get("abc")), (String)"123");
        Assert.assertTrue((boolean)queryParams.containsKey("Signature"));
        Assert.assertNotNull(queryParams.get("Signature"));
        Assert.assertTrue((boolean)queryParams.containsKey("SigAlg"));
        Assert.assertEquals((String)((String)queryParams.get("SigAlg")), (String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Assert.assertTrue((boolean)queryParams.containsKey("RelayState"));
        Assert.assertEquals((String)((String)queryParams.get("RelayState")), (String)"relay");
        Assert.assertTrue((boolean)queryParams.containsKey("SAMLResponse"));
        try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(Base64Support.decode((String)((String)queryParams.get("SAMLResponse")))), new Inflater(true));){
            Document outboundResponse = parserPool.parse((InputStream)inflater);
            this.assertXMLEquals(outboundResponse, (XMLObject)samlMessage);
        }
        String signatureWithParams = (String)queryParams.get("Signature");
        Assert.assertEquals((String)signatureWithoutParams, (String)signatureWithParams);
    }
}

