/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.velocity.app.VelocityEngine;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostEncoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPPostEncoderTest
extends XMLObjectBaseTestCase {
    private VelocityEngine velocityEngine;

    @BeforeMethod
    public void setUp() throws Exception {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("input.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("output.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
        this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.init();
    }

    @Test
    public void testResponseEncoding() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPPostEncoder encoder = new HTTPPostEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.setVelocityEngine(this.velocityEngine);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/html", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Document webDoc = Jsoup.parse((String)response.getContentAsString());
        boolean sawDocType = false;
        List nods = webDoc.childNodes();
        for (Node node : nods) {
            if (!(node instanceof DocumentType)) continue;
            sawDocType = true;
            DocumentType documentType = (DocumentType)node;
            Assert.assertEquals((String)documentType.attr("name"), (String)"html");
            Assert.assertEquals((String)documentType.attr("publicId"), (String)"");
            Assert.assertEquals((String)documentType.attr("systemId"), (String)"");
        }
        Assert.assertTrue((boolean)sawDocType);
        Element head = webDoc.selectFirst("html > head");
        Assert.assertNotNull((Object)head);
        Element metaCharSet = head.selectFirst("meta[charset]");
        Assert.assertNotNull((Object)metaCharSet);
        Assert.assertEquals((String)metaCharSet.attr("charset").toLowerCase(), (String)"utf-8");
        Element body = webDoc.selectFirst("html > body");
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((String)body.attr("onload"), (String)"document.forms[0].submit()");
        Element form = body.selectFirst("form");
        Assert.assertNotNull((Object)form);
        Assert.assertEquals((String)form.attr("method").toLowerCase(), (String)"post");
        Assert.assertEquals((String)form.attr("action"), (String)"http://example.org/response");
        Element relayState = form.selectFirst("input[name=RelayState]");
        Assert.assertNotNull((Object)relayState);
        Assert.assertEquals((String)relayState.val(), (String)"relay");
        Element noscriptMsg = body.selectFirst("noscript > p");
        Assert.assertNotNull((Object)noscriptMsg);
        Assert.assertTrue((boolean)noscriptMsg.text().contains("Since your browser does not support JavaScript"));
        Element samlResponse = form.selectFirst("input[name=SAMLResponse]");
        Assert.assertNotNull((Object)samlResponse);
        Assert.assertNotNull((Object)samlResponse.val());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Support.decode((String)samlResponse.val()));){
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)inputStream);
            Assert.assertTrue((boolean)(xmlObject instanceof Response));
            this.assertXMLEquals(xmlObject.getDOM().getOwnerDocument(), (XMLObject)samlMessage);
        }
        Element submit = body.selectFirst("noscript > div > input[type=submit]");
        Assert.assertNotNull((Object)submit);
        Assert.assertEquals((String)submit.val(), (String)"Continue");
    }

    @Test
    public void testRequestEncoding() throws Exception {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest samlMessage = (AuthnRequest)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(new DateTime(0L));
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        SAMLOutboundDestinationHandler handler = new SAMLOutboundDestinationHandler();
        handler.invoke(messageContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPPostEncoder encoder = new HTTPPostEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse((HttpServletResponse)response);
        encoder.setVelocityEngine(this.velocityEngine);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/html", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Document webDoc = Jsoup.parse((String)response.getContentAsString());
        boolean sawDocType = false;
        List nods = webDoc.childNodes();
        for (Node node : nods) {
            if (!(node instanceof DocumentType)) continue;
            sawDocType = true;
            DocumentType documentType = (DocumentType)node;
            Assert.assertEquals((String)documentType.attr("name"), (String)"html");
            Assert.assertEquals((String)documentType.attr("publicId"), (String)"");
            Assert.assertEquals((String)documentType.attr("systemId"), (String)"");
        }
        Assert.assertTrue((boolean)sawDocType);
        Element head = webDoc.selectFirst("html > head");
        Assert.assertNotNull((Object)head);
        Element metaCharSet = head.selectFirst("meta[charset]");
        Assert.assertNotNull((Object)metaCharSet);
        Assert.assertEquals((String)metaCharSet.attr("charset").toLowerCase(), (String)"utf-8");
        Element body = webDoc.selectFirst("html > body");
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((String)body.attr("onload"), (String)"document.forms[0].submit()");
        Element form = body.selectFirst("form");
        Assert.assertNotNull((Object)form);
        Assert.assertEquals((String)form.attr("method").toLowerCase(), (String)"post");
        Assert.assertEquals((String)form.attr("action"), (String)"http://example.org");
        Element relayState = form.selectFirst("input[name=RelayState]");
        Assert.assertNotNull((Object)relayState);
        Assert.assertEquals((String)relayState.val(), (String)"relay");
        Element noscriptMsg = body.selectFirst("noscript > p");
        Assert.assertNotNull((Object)noscriptMsg);
        Assert.assertTrue((boolean)noscriptMsg.text().contains("Since your browser does not support JavaScript"));
        Element samlResponse = form.selectFirst("input[name=SAMLRequest]");
        Assert.assertNotNull((Object)samlResponse);
        Assert.assertNotNull((Object)samlResponse.val());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Support.decode((String)samlResponse.val()));){
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)inputStream);
            Assert.assertTrue((boolean)(xmlObject instanceof AuthnRequest));
            this.assertXMLEquals(xmlObject.getDOM().getOwnerDocument(), (XMLObject)samlMessage);
        }
        Element submit = body.selectFirst("noscript > div > input[type=submit]");
        Assert.assertNotNull((Object)submit);
        Assert.assertEquals((String)submit.val(), (String)"Continue");
    }
}

