/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.util.Map;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.assertion.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.assertion.impl.OneTimeUseConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OneTimeUseConditionValidatorTest
extends BaseAssertionValidationTest {
    private MemoryStorageService storageService;
    private ReplayCache replayCache;
    private OneTimeUseConditionValidator validator;
    private Condition condition;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() throws ComponentInitializationException {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("mySS");
        this.storageService.initialize();
        this.replayCache = new ReplayCache();
        this.replayCache.setId("myRC");
        this.replayCache.setStorage((StorageService)this.storageService);
        this.replayCache.initialize();
        this.validator = new OneTimeUseConditionValidator(this.replayCache, null);
        this.condition = (Condition)this.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME);
        this.getAssertion().getConditions().getConditions().add(this.condition);
    }

    @AfterMethod
    public void tearDown() {
        this.replayCache.destroy();
        this.storageService.destroy();
    }

    @Test
    public void testNoReplay() throws AssertionValidationException, InterruptedException {
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
        Thread.sleep(1000L);
        assertion.setID(assertion.getID() + "moreID");
        validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testReplay() throws AssertionValidationException, InterruptedException {
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
        Thread.sleep(1000L);
        validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testReplayWithGlobalExpiration() throws AssertionValidationException, InterruptedException {
        this.validator = new OneTimeUseConditionValidator(this.replayCache, Long.valueOf(500L));
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
        Thread.sleep(1000L);
        validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testReplayWithExpirationParam() throws AssertionValidationException, InterruptedException {
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.OneTimeUseExpires", 500L);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
        Thread.sleep(1000L);
        validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidExpirationParam() throws AssertionValidationException, InterruptedException {
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.OneTimeUseExpires", "500");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.VALID);
        Thread.sleep(1000L);
        validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testUnexpectedCondition() throws AssertionValidationException {
        this.condition = (Condition)this.getBuilder(DelegationRestrictionType.TYPE_NAME).buildObject(Condition.DEFAULT_ELEMENT_NAME, DelegationRestrictionType.TYPE_NAME);
        Assertion assertion = this.getAssertion();
        Assert.assertNotNull((Object)StringSupport.trimOrNull((String)assertion.getID()));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, assertion, validationContext), (Object)ValidationResult.INDETERMINATE);
    }
}

