/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.assertion.impl.AbstractSubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractSubjectConfirmationValidatorTest
extends BaseAssertionValidationTest {
    private MockSubjectConfirmationValidator validator;
    private SubjectConfirmation subjectConfirmation;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new MockSubjectConfirmationValidator();
        this.subjectConfirmation = (SubjectConfirmation)this.getAssertion().getSubject().getSubjectConfirmations().get(0);
        this.subjectConfirmation.setMethod(this.validator.getServicedMethod());
    }

    @Test
    public void testValidConfirmationData() throws AssertionValidationException {
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoConfirmationData() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidAddress() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress("1.2.3.4");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidAddressParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.ValidAddresses", "10.1.2.3");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingAddressParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.SubjectConfirmation.ValidAddresses");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoAddress() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidRecipient() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setRecipient("https://bogussp.example.com");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidRecipientParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.ValidRecipients", "https://sp.example.com");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingRecipientParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.SubjectConfirmation.ValidRecipients");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoRecipient() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setRecipient(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidNotBefore() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(new DateTime().plusMinutes(30));
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(new DateTime().plusMinutes(60));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoNotBefore() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidNotOnOrAfter() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(new DateTime().minusMinutes(60));
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(new DateTime().minusMinutes(30));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoNotOnOrAfter() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    public static class MockSubjectConfirmationValidator
    extends AbstractSubjectConfirmationValidator {
        public String getServicedMethod() {
            return "urn:test:foo";
        }

        @Nonnull
        protected ValidationResult doValidate(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
            return ValidationResult.VALID;
        }
    }
}

