/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import java.util.Arrays;
import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml1.profile.impl.AddSubjectConfirmationToSubjects;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddSubjectConfirmationToSubjectsTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext<Object, Response> prc;
    private AddSubjectConfirmationToSubjects action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new AddSubjectConfirmationToSubjects();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testBadConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.action.setMethods(Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent(this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        this.action.setMethods(Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    public void testNoStatements() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        this.action.setMethods(Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertTrue((boolean)((Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0)).getStatements().isEmpty());
    }

    @Test
    void testSingle() throws ComponentInitializationException {
        this.addStatements();
        this.action.setMethods(Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
        Assert.assertEquals((int)subject.getSubjectConfirmation().getConfirmationMethods().size(), (int)1);
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(0)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:bearer");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
        Assert.assertEquals((int)subject.getSubjectConfirmation().getConfirmationMethods().size(), (int)1);
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(0)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:bearer");
    }

    @Test
    void testMultiple() throws ComponentInitializationException {
        this.addStatements();
        this.action.setMethods(Arrays.asList("urn:oasis:names:tc:SAML:1.0:cm:bearer", "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
        Assert.assertEquals((int)subject.getSubjectConfirmation().getConfirmationMethods().size(), (int)2);
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(0)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:bearer");
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(1)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
        Assert.assertEquals((int)subject.getSubjectConfirmation().getConfirmationMethods().size(), (int)2);
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(0)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:bearer");
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(1)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
    }

    @Test
    void testArtifact() throws ComponentInitializationException {
        this.addStatements();
        ((SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class, true)).setBindingUri("urn:oasis:names:tc:SAML:1.0:profiles:artifact-01");
        this.action.setMethods(Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
        Assert.assertEquals((int)subject.getSubjectConfirmation().getConfirmationMethods().size(), (int)1);
        Assert.assertEquals((String)((ConfirmationMethod)subject.getSubjectConfirmation().getConfirmationMethods().get(0)).getConfirmationMethod(), (String)"urn:oasis:names:tc:SAML:1.0:cm:artifact");
    }

    private void addStatements() {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ((Assertion)response.getAssertions().get(0)).getAuthenticationStatements().add(SAML1ActionTestingSupport.buildAuthenticationStatement());
        ((Assertion)response.getAssertions().get(1)).getAttributeStatements().add(SAML1ActionTestingSupport.buildAttributeStatement());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
    }
}

