/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml1.profile.impl.AddResponseShell;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddResponseShellTest
extends OpenSAMLInitBaseTestCase {
    private AddResponseShell action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddResponseShell();
        this.action.initialize();
    }

    @Test
    public void testAddResponse() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        MessageContext outMsgCtx = prc.getOutboundMessageContext();
        Response response = (Response)outMsgCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_11);
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((Object)status.getStatusCode().getValue(), (Object)StatusCode.SUCCESS);
    }

    @Test
    public void testAddResponseWhenResponseAlreadyExist() {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }
}

