/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;

    public SubjectTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleSubject.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/SubjectWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Subject subject = (Subject)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)subject.getNameIdentifier(), (String)"Non zero number of child NameIdentifier elements");
        Assert.assertNull((Object)subject.getSubjectConfirmation(), (String)"Non zero number of child SubjectConfirmation elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Subject subject = (Subject)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)subject.getNameIdentifier(), (String)"Zero child NameIdentifier elements");
        Assert.assertNotNull((Object)subject.getSubjectConfirmation(), (String)"Zero child SubjectConfirmation elements");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testChildElementsMarshall() {
        Subject subject = (Subject)this.buildXMLObject(this.qname);
        QName oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier", "saml1");
        subject.setNameIdentifier((NameIdentifier)this.buildXMLObject(oqname));
        oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation", "saml1");
        subject.setSubjectConfirmation((SubjectConfirmation)this.buildXMLObject(oqname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subject);
    }
}

