/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusMessageTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String contents;

    public StatusMessageTest() {
        this.contents = "Nibble a Happy Warthog";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleStatusMessage.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/FullStatusMessage.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage", "saml1p");
    }

    @Test
    public void testSingleElementUnmarshall() {
        StatusMessage statusMessage = (StatusMessage)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)statusMessage.getMessage(), (String)"Contents");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        StatusMessage statusMessage = (StatusMessage)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)statusMessage.getMessage(), (String)this.contents, (String)"Contents");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        StatusMessage statusMessage = (StatusMessage)this.buildXMLObject(this.qname);
        statusMessage.setMessage(this.contents);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)statusMessage);
    }
}

