/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResponseTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedID;
    private final DateTime expectedIssueInstant;
    private final String expectedInResponseTo;
    private final int expectedMinorVersion;
    private final String expectedRecipient;

    public ResponseTest() {
        this.expectedID = "ident";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleResponse.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleResponseAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/ResponseWithChildren.xml";
        this.expectedIssueInstant = new DateTime(1970, 1, 1, 0, 0, 0, 100, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedInResponseTo = "inresponseto";
        this.expectedMinorVersion = 1;
        this.expectedRecipient = "recipient";
        this.qname = Response.DEFAULT_ELEMENT_NAME;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Response response = (Response)this.unmarshallElement(this.singleElementFile);
        String id = response.getID();
        Assert.assertNull((Object)id, (String)("ID attribute has value " + id + "expected no value"));
        Assert.assertNull((Object)response.getIssueInstant(), (String)("IssueInstant attribute has a value of " + response.getIssueInstant() + ", expected no value"));
        Assert.assertEquals((int)response.getAssertions().size(), (int)0, (String)"Assertion elements count");
        Status status = response.getStatus();
        Assert.assertNull((Object)status, (String)("Status element has a value of " + status + ", expected no value"));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Response response = (Response)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)response.getID(), (String)this.expectedID, (String)"ID");
        Assert.assertEquals((Object)response.getIssueInstant(), (Object)this.expectedIssueInstant, (String)"IssueInstant attribute ");
        String string = response.getInResponseTo();
        Assert.assertEquals((String)string, (String)this.expectedInResponseTo, (String)"InResponseTo attribute ");
        string = response.getRecipient();
        Assert.assertEquals((String)string, (String)this.expectedRecipient, (String)"Recipient attribute ");
        int i = response.getVersion().getMinorVersion();
        Assert.assertEquals((int)i, (int)this.expectedMinorVersion, (String)"MinorVersion attribute ");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Response response = (Response)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)response.getAssertions().size(), (int)1, (String)"No Assertion elements count");
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status, (String)"No Status element found");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Response response = (Response)this.buildXMLObject(this.qname);
        response.setID(this.expectedID);
        response.setInResponseTo(this.expectedInResponseTo);
        response.setIssueInstant(this.expectedIssueInstant);
        response.setRecipient(this.expectedRecipient);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)response);
    }

    @Test
    public void testChildElementsMarshall() {
        Response response = (Response)this.buildXMLObject(this.qname);
        response.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        response.setStatus((Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)response);
    }

    @Test
    public void testSignatureUnmarshall() {
        Response response = (Response)this.unmarshallElement("/org/opensaml/saml/saml1/impl/ResponseWithSignature.xml");
        Assert.assertNotNull((Object)response, (String)"Response was null");
        Assert.assertNotNull((Object)response.getSignature(), (String)"Signature was null");
        Assert.assertNotNull((Object)response.getSignature().getKeyInfo(), (String)"KeyInfo was null");
    }

    @Test
    public void testDOMIDResolutionUnmarshall() {
        Response response = (Response)this.unmarshallElement("/org/opensaml/saml/saml1/impl/ResponseWithSignature.xml");
        Assert.assertNotNull((Object)response, (String)"Response was null");
        Assert.assertNotNull((Object)response.getSignature(), (String)"Signature was null");
        Document document = response.getSignature().getDOM().getOwnerDocument();
        Element idElem = response.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }

    @Test
    public void testDOMIDResolutionMarshall() throws MarshallingException {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setID(this.expectedID);
        response.setStatus((Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME));
        marshallerFactory.getMarshaller((XMLObject)response).marshall((XMLObject)response);
        Document document = response.getStatus().getDOM().getOwnerDocument();
        Element idElem = response.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }
}

