/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NameIdentifierTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private String expectedNameIdentifier;
    private String expectedFormat;
    private String expectedNameQualifier;

    public NameIdentifierTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleNameIdentifier.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleNameIdentifierAttributes.xml";
        this.expectedFormat = "format";
        this.expectedNameIdentifier = "IdentifierText";
        this.expectedNameQualifier = "Qualifier";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        NameIdentifier nameIdentifier = (NameIdentifier)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)nameIdentifier.getValue(), (String)"Name Identifer contents present");
        Assert.assertNull((Object)nameIdentifier.getNameQualifier(), (String)"NameQualifier present");
        Assert.assertNull((Object)nameIdentifier.getFormat(), (String)"Format present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        NameIdentifier nameIdentifier = (NameIdentifier)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)nameIdentifier.getValue(), (String)this.expectedNameIdentifier, (String)"Name Identifier contents");
        Assert.assertEquals((String)nameIdentifier.getNameQualifier(), (String)this.expectedNameQualifier, (String)"NameQualfier attribute");
        Assert.assertEquals((String)nameIdentifier.getFormat(), (String)this.expectedFormat, (String)"Format attribute");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        NameIdentifier nameIdentifier = (NameIdentifier)this.buildXMLObject(this.qname);
        nameIdentifier.setFormat(this.expectedFormat);
        nameIdentifier.setValue(this.expectedNameIdentifier);
        nameIdentifier.setNameQualifier(this.expectedNameQualifier);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)nameIdentifier);
    }
}

