/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorityBinding;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectLocality;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationStatementTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private String expectedAuthenticationMethod = "trustme";
    private DateTime expectedAuthenticationInstant = new DateTime(1970, 1, 2, 1, 1, 2, 123, (Chronology)ISOChronology.getInstanceUTC());

    public AuthenticationStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAuthenticationStatement.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthenticationStatementAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AuthenticationStatementWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)authenticationStatement.getAuthenticationMethod(), (String)"AuthenticationMethod attribute present");
        Assert.assertNull((Object)authenticationStatement.getAuthenticationInstant(), (String)"AuthenticationInstant attribute present");
        Assert.assertNull((Object)authenticationStatement.getSubject(), (String)"<Subject> element present");
        Assert.assertNull((Object)authenticationStatement.getSubjectLocality(), (String)"<SubjectLocailty> element present");
        Assert.assertEquals((int)authenticationStatement.getAuthorityBindings().size(), (int)0, (String)"Non zero count of <AuthorityBinding> elements");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)authenticationStatement.getAuthenticationMethod(), (String)this.expectedAuthenticationMethod, (String)"AuthenticationMethod");
        Assert.assertEquals((Object)authenticationStatement.getAuthenticationInstant(), (Object)this.expectedAuthenticationInstant, (String)"AuthenticationInstant");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authenticationStatement.getSubject(), (String)"<Subject> element not present");
        Assert.assertNotNull((Object)authenticationStatement.getSubjectLocality(), (String)"<SubjectLocality> element not present");
        Assert.assertNotNull((Object)authenticationStatement.getAuthorityBindings(), (String)"<AuthorityBinding> elements not present");
        Assert.assertEquals((int)authenticationStatement.getAuthorityBindings().size(), (int)2, (String)"count of <AuthorityBinding> elements");
        AuthorityBinding authorityBinding = (AuthorityBinding)authenticationStatement.getAuthorityBindings().get(0);
        authenticationStatement.getAuthorityBindings().remove(authorityBinding);
        Assert.assertEquals((int)authenticationStatement.getAuthorityBindings().size(), (int)1, (String)"count of <AuthorityBinding> elements");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)this.buildXMLObject(this.qname);
        authenticationStatement.setAuthenticationInstant(this.expectedAuthenticationInstant);
        authenticationStatement.setAuthenticationMethod(this.expectedAuthenticationMethod);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authenticationStatement);
    }

    @Test
    public void testChildElementsMarshall() {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)this.buildXMLObject(this.qname);
        authenticationStatement.setSubject((Subject)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1")));
        authenticationStatement.setSubjectLocality((SubjectLocality)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality", "saml1")));
        QName authQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding", "saml1");
        authenticationStatement.getAuthorityBindings().add((AuthorityBinding)this.buildXMLObject(authQname));
        authenticationStatement.getAuthorityBindings().add((AuthorityBinding)this.buildXMLObject(authQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authenticationStatement);
    }
}

