/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.Audience;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AudienceTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedUri;

    public AudienceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAudience.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAudienceAttributes.xml";
        this.expectedUri = "urn:oasis:names:tc:SAML:1.0:assertion";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Audience", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Audience audience = (Audience)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)audience.getUri(), (String)"Uri is non-null");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Audience audience = (Audience)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)audience.getUri(), (String)this.expectedUri, (String)"Uri");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Audience audience = (Audience)this.buildXMLObject(this.qname);
        audience.setUri(this.expectedUri);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)audience);
    }
}

