/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedAttributeName;
    private final String expectedAttributeNamespace;

    public AttributeTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAttribute.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAttributeAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AttributeWithChildren.xml";
        this.expectedAttributeName = "AttributeName";
        this.expectedAttributeNamespace = "namespace";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Attribute attribute = (Attribute)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)attribute.getAttributeName(), (String)"AttributeName");
        Assert.assertNull((Object)attribute.getAttributeNamespace(), (String)"AttributeNamespace");
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)0, (String)"<AttributeValue> subelement found");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Attribute attribute = (Attribute)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attribute.getAttributeName(), (String)this.expectedAttributeName, (String)"AttributeName");
        Assert.assertEquals((String)attribute.getAttributeNamespace(), (String)this.expectedAttributeNamespace, (String)"AttributeNamespace");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Attribute attribute = (Attribute)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)attribute.getAttributeValues(), (String)"<AttributeValue> subelement not found");
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)4, (String)"Number of <AttributeValue> subelement not found");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Attribute attribute = (Attribute)this.buildXMLObject(this.qname);
        attribute.setAttributeName(this.expectedAttributeName);
        attribute.setAttributeNamespace(this.expectedAttributeNamespace);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attribute);
    }

    @Test
    public void testChildElementsMarshall() {
        Attribute attribute = (Attribute)this.buildXMLObject(this.qname);
        XMLObjectBuilder attributeValueBuilder = builderFactory.getBuilderOrThrow(XSString.TYPE_NAME);
        attribute.getAttributeValues().add(attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME));
        attribute.getAttributeValues().add(attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME));
        attribute.getAttributeValues().add(attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME));
        attribute.getAttributeValues().add(attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attribute);
    }
}

