/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Subject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeStatementTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;

    public AttributeStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAttributeStatement.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AttributeStatementWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)attributeStatement.getSubject(), (String)"<Subject> element present");
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)0, (String)"Non zero count of <Attribute> elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)attributeStatement.getSubject(), (String)"<Subject> element not present");
        Assert.assertNotNull((Object)attributeStatement.getAttributes(), (String)"<AuthorityBinding> elements not present");
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)5, (String)"count of <AuthorityBinding> elements");
        Attribute attribute = (Attribute)attributeStatement.getAttributes().get(0);
        attributeStatement.getAttributes().remove(attribute);
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)4, (String)"count of <AttributeStatement> elements after single remove");
        ArrayList list = new ArrayList(2);
        list.add(attributeStatement.getAttributes().get(0));
        list.add(attributeStatement.getAttributes().get(2));
        attributeStatement.getAttributes().removeAll(list);
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)2, (String)"count of <AttributeStatement> elements after double remove");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.buildXMLObject(this.qname);
        attributeStatement.setSubject((Subject)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1")));
        QName oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute", "saml1");
        for (int i = 0; i < 5; ++i) {
            attributeStatement.getAttributes().add((Attribute)this.buildXMLObject(oqname));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributeStatement);
    }
}

