/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Subject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeQueryTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedResource;

    public AttributeQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAttributeQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAttributeQueryAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AttributeQueryWithChildren.xml";
        this.expectedResource = "resource";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery", "saml1p");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeQuery attributeQuery = (AttributeQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)attributeQuery.getResource(), (String)"Resource attribute present");
        Assert.assertNull((Object)attributeQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)attributeQuery.getAttributeDesignators().size(), (int)0, (String)"Count of AttributeDesignator elements");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeQuery attributeQuery = (AttributeQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attributeQuery.getResource(), (String)this.expectedResource, (String)"Resource attribute");
        Assert.assertNull((Object)attributeQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)attributeQuery.getAttributeDesignators().size(), (int)0, (String)"Count of AttributeDesignator elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeQuery attributeQuery = (AttributeQuery)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)attributeQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)attributeQuery.getAttributeDesignators().size(), (int)4, (String)"Count of AttributeDesignator elements");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeQuery attributeQuery = (AttributeQuery)this.buildXMLObject(this.qname);
        attributeQuery.setResource(this.expectedResource);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeQuery);
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeQuery attributeQuery = (AttributeQuery)this.buildXMLObject(this.qname);
        attributeQuery.setSubject((Subject)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1")));
        List list = attributeQuery.getAttributeDesignators();
        QName attqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator", "saml1");
        list.add((AttributeDesignator)this.buildXMLObject(attqname));
        list.add((AttributeDesignator)this.buildXMLObject(attqname));
        list.add((AttributeDesignator)this.buildXMLObject(attqname));
        list.add((AttributeDesignator)this.buildXMLObject(attqname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributeQuery);
    }
}

