/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AssertionIDReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdviceTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;

    public AdviceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAdvice.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AdviceWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Advice", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Advice advice = (Advice)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)advice.getAssertionIDReferences().size(), (int)0, (String)"Number of child AssertIDReference elements");
        Assert.assertEquals((int)advice.getAssertions().size(), (int)0, (String)"Number of child Assertion elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Advice advice = (Advice)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)advice.getAssertionIDReferences().size(), (int)2, (String)"Number of child AssertIDReference elements");
        Assert.assertEquals((int)advice.getAssertions().size(), (int)1, (String)"Number of child Assertion elements");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testChildElementsMarshall() {
        Advice advice = (Advice)this.buildXMLObject(this.qname);
        QName assertionIDRefQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference", "saml1");
        QName assertionQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion", "saml1");
        advice.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(assertionIDRefQname));
        advice.getAssertions().add((Assertion)this.buildXMLObject(assertionQname));
        advice.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(assertionIDRefQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)advice);
    }
}

