/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.RoleDescriptorImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RoleMetadataIndexTest
extends XMLObjectBaseTestCase {
    private RoleMetadataIndex metadataIndex;
    private EntityDescriptor idp;
    private EntityDescriptor sp;
    private EntityDescriptor idpAndSp;
    private EntityDescriptor custom;
    private MetadataIndexKey keyIDP;
    private MetadataIndexKey keySP;
    private MetadataIndexKey keyCustom;

    @BeforeClass
    protected void setUp() {
        this.metadataIndex = new RoleMetadataIndex();
        this.keyIDP = new RoleMetadataIndex.RoleMetadataIndexKey(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.keySP = new RoleMetadataIndex.RoleMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.keyCustom = new RoleMetadataIndex.RoleMetadataIndexKey(MyCustomRoleType.TYPE_NAME);
        this.idp = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.idp.setEntityID("urn:test:idp");
        this.idp.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.sp = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.sp.setEntityID("urn:test:sp");
        this.sp.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.idpAndSp = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.idpAndSp.setEntityID("urn:test:idpAndSp");
        this.idpAndSp.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.idpAndSp.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.custom = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.custom.setEntityID("urn:test:custom");
        this.custom.getRoleDescriptors().add(new MyCustomRoleType(MyCustomRoleType.TYPE_NAME.getNamespaceURI(), MyCustomRoleType.TYPE_NAME.getLocalPart(), MyCustomRoleType.TYPE_NAME.getPrefix()));
    }

    @Test
    public void testGenerateKeysFromDescriptor() {
        Set keys = null;
        keys = this.metadataIndex.generateKeys(this.idp);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyIDP));
        keys = this.metadataIndex.generateKeys(this.sp);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keySP));
        keys = this.metadataIndex.generateKeys(this.idpAndSp);
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.contains(this.keyIDP));
        Assert.assertTrue((boolean)keys.contains(this.keySP));
        keys = this.metadataIndex.generateKeys(this.custom);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyCustom));
    }

    @Test
    public void testGenerateKeysFromCriteria() {
        CriteriaSet criteriaSet = new CriteriaSet();
        Set keys = null;
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyIDP));
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keySP));
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(MyCustomRoleType.TYPE_NAME));
        keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyCustom));
    }

    public static class MyCustomRoleType
    extends RoleDescriptorImpl {
        public static final QName TYPE_NAME = new QName("urn:test:metadata", "MyCustomRoleType", "custom");

        protected MyCustomRoleType(String namespaceURI, String elementLocalName, String namespacePrefix) {
            super(namespaceURI, elementLocalName, namespacePrefix);
        }

        public List<Endpoint> getEndpoints() {
            return null;
        }

        public List<Endpoint> getEndpoints(QName type) {
            return null;
        }
    }
}

