/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.StartsWithLocationCriterion;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.EndpointMetadataIndex;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EndpointMetadataIndexTest
extends XMLObjectBaseTestCase {
    private String entityID = "https://www.example.com/saml";
    private EntityDescriptor descriptor;
    private SPSSODescriptor spRoleDescriptor;
    private IDPSSODescriptor idpRoleDescriptor;
    private AssertionConsumerService endpoint1;
    private ArtifactResolutionService endpoint2;
    private ArtifactResolutionService idpEndpoint;
    private String location1 = "https://www.example.com/saml/someEndpoint1";
    private String location2 = "https://www.example.com/saml/someEndpoint2";
    private String responseLocation1 = "https://www.example.com/saml/someResponseEndpoint1";
    private String idpLocation = "https://idp.example.com/saml/someEndpoint";
    private MetadataIndexKey endpointKey1;
    private MetadataIndexKey endpointKey2;
    private MetadataIndexKey responseEndpointKey1;
    private MetadataIndexKey idpEndpointKey;

    @BeforeMethod
    protected void setUp() {
        this.descriptor = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.descriptor.setEntityID(this.entityID);
        this.spRoleDescriptor = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.descriptor.getRoleDescriptors().add(this.spRoleDescriptor);
        this.idpRoleDescriptor = (IDPSSODescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.descriptor.getRoleDescriptors().add(this.idpRoleDescriptor);
        this.endpoint1 = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        this.endpoint1.setLocation(this.location1);
        this.endpoint1.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        this.endpoint2 = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        this.endpoint2.setLocation(this.location2);
        this.endpoint2.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        this.idpEndpoint = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        this.idpEndpoint.setLocation(this.idpLocation);
        this.idpEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        this.spRoleDescriptor.getAssertionConsumerServices().add(this.endpoint1);
        this.spRoleDescriptor.getArtifactResolutionServices().add(this.endpoint2);
        this.endpointKey1 = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.location1, false);
        this.endpointKey2 = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, ArtifactResolutionService.DEFAULT_ELEMENT_NAME, this.location2, false);
        this.idpEndpointKey = new EndpointMetadataIndex.EndpointMetadataIndexKey(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, ArtifactResolutionService.DEFAULT_ELEMENT_NAME, this.idpLocation, false);
        this.responseEndpointKey1 = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.responseLocation1, true);
    }

    @Test
    public void testGenerateKeysFromCriteria() {
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex();
        CriteriaSet criteriaSet = new CriteriaSet();
        Set keys = null;
        Endpoint endpoint = null;
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        keys = metadataIndex.generateKeys(criteriaSet);
        Assert.assertNull((Object)keys);
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        endpoint = (Endpoint)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation(this.location1);
        criteriaSet.add((Object)new EndpointCriterion(endpoint));
        keys = metadataIndex.generateKeys(criteriaSet);
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        endpoint = (Endpoint)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation(this.location1);
        endpoint.setResponseLocation(this.responseLocation1);
        criteriaSet.add((Object)new EndpointCriterion(endpoint));
        keys = metadataIndex.generateKeys(criteriaSet);
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
        Assert.assertTrue((boolean)keys.contains(this.responseEndpointKey1));
        criteriaSet.clear();
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        endpoint = (Endpoint)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation("https://www.example.com/cas/someEndpoint1/foo/bar/");
        criteriaSet.add((Object)new EndpointCriterion(endpoint));
        criteriaSet.add((Object)new StartsWithLocationCriterion());
        keys = metadataIndex.generateKeys(criteriaSet);
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((int)keys.size(), (int)10);
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1/foo/bar/", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1/foo/bar", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1/foo/", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1/foo", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1/", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/someEndpoint1", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas/", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/cas", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com/", false)));
        Assert.assertTrue((boolean)keys.contains(new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "https://www.example.com", false)));
    }

    @Test
    public void testGenerateKeysFromDescriptorAlwaysFalseSelector() {
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex(Predicates.alwaysFalse());
        Set keys = metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testGenerateKeysFromDescriptorDefaultCtor() {
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex();
        Set keys = metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
        Assert.assertTrue((boolean)keys.contains(this.endpointKey2));
    }

    @Test
    public void testGenerateKeysFromDescriptorTwoRoles() {
        this.idpRoleDescriptor.getArtifactResolutionServices().add(this.idpEndpoint);
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex();
        Set keys = metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)3);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
        Assert.assertTrue((boolean)keys.contains(this.endpointKey2));
        Assert.assertTrue((boolean)keys.contains(this.idpEndpointKey));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithResponseLocation() {
        this.endpoint1.setResponseLocation(this.responseLocation1);
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex();
        Set keys = metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)3);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
        Assert.assertTrue((boolean)keys.contains(this.endpointKey2));
        Assert.assertTrue((boolean)keys.contains(this.responseEndpointKey1));
    }

    @Test
    public void testGenerateKeysFromDescriptorIndexOnlyACS() {
        HashMap<QName, HashSet> indexableEndpoints = new HashMap<QName, HashSet>();
        indexableEndpoints.put(SPSSODescriptor.DEFAULT_ELEMENT_NAME, Sets.newHashSet((Object[])new QName[]{AssertionConsumerService.DEFAULT_ELEMENT_NAME}));
        EndpointMetadataIndex metadataIndex = new EndpointMetadataIndex((Predicate)new EndpointMetadataIndex.DefaultEndpointSelectionPredicate(indexableEndpoints));
        Set keys = metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.endpointKey1));
    }

    @Test
    public void testDefaultEndpointSelectionPredicate() {
        AssertionConsumerService endpoint = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation(this.location1);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SPSSODescriptor role = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        role.getAssertionConsumerServices().add(endpoint);
        EndpointMetadataIndex.DefaultEndpointSelectionPredicate predicate = new EndpointMetadataIndex.DefaultEndpointSelectionPredicate();
        Assert.assertFalse((boolean)predicate.apply((Object)endpoint));
        Map<QName, HashSet> indexableEndpoints = Collections.emptyMap();
        predicate = new EndpointMetadataIndex.DefaultEndpointSelectionPredicate(indexableEndpoints);
        Assert.assertFalse((boolean)predicate.apply((Object)endpoint));
        indexableEndpoints = new HashMap();
        indexableEndpoints.put(SPSSODescriptor.DEFAULT_ELEMENT_NAME, Sets.newHashSet((Object[])new QName[]{ArtifactResolutionService.DEFAULT_ELEMENT_NAME}));
        predicate = new EndpointMetadataIndex.DefaultEndpointSelectionPredicate(indexableEndpoints);
        Assert.assertFalse((boolean)predicate.apply((Object)endpoint));
        indexableEndpoints = new HashMap();
        indexableEndpoints.put(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, Sets.newHashSet((Object[])new QName[]{ArtifactResolutionService.DEFAULT_ELEMENT_NAME}));
        predicate = new EndpointMetadataIndex.DefaultEndpointSelectionPredicate(indexableEndpoints);
        Assert.assertFalse((boolean)predicate.apply((Object)endpoint));
        indexableEndpoints = new HashMap();
        indexableEndpoints.put(SPSSODescriptor.DEFAULT_ELEMENT_NAME, Sets.newHashSet((Object[])new QName[]{AssertionConsumerService.DEFAULT_ELEMENT_NAME}));
        predicate = new EndpointMetadataIndex.DefaultEndpointSelectionPredicate(indexableEndpoints);
        Assert.assertTrue((boolean)predicate.apply((Object)endpoint));
    }

    @Test
    public void testEndpointKey() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        EndpointMetadataIndex.EndpointMetadataIndexKey keySame = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.location1, false);
        EndpointMetadataIndex.EndpointMetadataIndexKey keySameCanonicalized = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, "HTTPS://WWW.EXAMPLE.COM:443/saml/someEndpoint1?foo=x&bar=y#someFragment", false);
        EndpointMetadataIndex.EndpointMetadataIndexKey keyDifferentRole = new EndpointMetadataIndex.EndpointMetadataIndexKey(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.location1, false);
        EndpointMetadataIndex.EndpointMetadataIndexKey keyDifferentEndpointType = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, SingleSignOnService.DEFAULT_ELEMENT_NAME, this.location1, false);
        EndpointMetadataIndex.EndpointMetadataIndexKey keyDifferentLocation = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.location2, false);
        EndpointMetadataIndex.EndpointMetadataIndexKey keyDifferentIsResponse = new EndpointMetadataIndex.EndpointMetadataIndexKey(SPSSODescriptor.DEFAULT_ELEMENT_NAME, AssertionConsumerService.DEFAULT_ELEMENT_NAME, this.location1, true);
        Assert.assertEquals((Object)this.endpointKey1, (Object)keySame);
        Assert.assertTrue((this.endpointKey1.hashCode() == keySame.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.endpointKey1, (Object)keySameCanonicalized);
        Assert.assertTrue((this.endpointKey1.hashCode() == keySameCanonicalized.hashCode() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)this.endpointKey1, (Object)keyDifferentRole);
        Assert.assertNotEquals((Object)this.endpointKey1, (Object)keyDifferentEndpointType);
        Assert.assertNotEquals((Object)this.endpointKey1, (Object)keyDifferentLocation);
        Assert.assertNotEquals((Object)this.endpointKey1, (Object)keyDifferentIsResponse);
    }
}

