/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SchemaValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChainingMetadataResolverTest
extends XMLObjectBaseTestCase {
    private ChainingMetadataResolver metadataProvider;
    private String entityID;
    private String entityID2;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        this.entityID2 = "urn:mace:switch.ch:SWITCHaai:ethz.ch";
        this.metadataProvider = new ChainingMetadataResolver();
        this.metadataProvider.setId("test MP provider");
        ArrayList<FilesystemMetadataResolver> resolvers = new ArrayList<FilesystemMetadataResolver>();
        URL mdURL = ChainingMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        File mdFile = new File(mdURL.toURI());
        FilesystemMetadataResolver fileProvider = new FilesystemMetadataResolver(mdFile);
        fileProvider.setParserPool(parserPool);
        fileProvider.setId("test");
        fileProvider.initialize();
        resolvers.add(fileProvider);
        URL mdURL2 = ChainingMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/metadata.switchaai_signed.xml");
        File mdFile2 = new File(mdURL2.toURI());
        FilesystemMetadataResolver fileProvider2 = new FilesystemMetadataResolver(mdFile2);
        fileProvider2.setParserPool(parserPool);
        fileProvider2.setRequireValidMetadata(false);
        fileProvider2.setId("fp2");
        fileProvider2.initialize();
        resolvers.add(fileProvider2);
        this.metadataProvider.setResolvers(resolvers);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
    }

    @Test
    public void testGetEntityDescriptor() throws ResolverException {
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)}));
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
        EntityDescriptor descriptor2 = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID2)}));
        Assert.assertNotNull((Object)descriptor2, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor2.getEntityID(), (String)this.entityID2, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testFilterDisallowed() {
        try {
            this.metadataProvider.setMetadataFilter((MetadataFilter)new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11)));
            Assert.fail((String)"Should fail with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

