/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.ext.saml2mdquery.AttributeQueryDescriptorType;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.BasicRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicRoleDescriptorResolverTest
extends XMLObjectBaseTestCase {
    private BasicRoleDescriptorResolver roleResolver;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        final EntityDescriptor entityDescriptor = this.buildTestDescriptor();
        MetadataResolver metadataResolver = new MetadataResolver(){

            @Nullable
            public String getId() {
                return "foo";
            }

            @Nullable
            public EntityDescriptor resolveSingle(CriteriaSet criteria) throws ResolverException {
                return entityDescriptor;
            }

            @Nonnull
            public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
                return Collections.singletonList(entityDescriptor);
            }

            public boolean isRequireValidMetadata() {
                return false;
            }

            public void setRequireValidMetadata(boolean requireValidMetadata) {
            }

            public MetadataFilter getMetadataFilter() {
                return null;
            }

            public void setMetadataFilter(MetadataFilter newFilter) {
            }
        };
        this.roleResolver = new BasicRoleDescriptorResolver(metadataResolver);
        this.roleResolver.initialize();
    }

    @Test
    public void testResolveSingleNoProtocol() throws ResolverException {
        RoleDescriptor roleDescriptor = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://www.example.org"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
    }

    @Test
    public void testResolveMultiNoProtocol() throws ResolverException {
        Iterable roleDescriptors = this.roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://www.example.org"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)2, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testResolveSingleWithProtocol() throws ResolverException {
        RoleDescriptor roleDescriptor = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://www.example.org"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
        Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
    }

    @Test
    public void testResolveMultiWithProtocol() throws ResolverException {
        Iterable roleDescriptors = this.roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://www.example.org"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
            ++count;
        }
        Assert.assertEquals((int)1, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    private EntityDescriptor buildTestDescriptor() {
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        SPSSODescriptor spssoDescriptor1 = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spssoDescriptor1.addSupportedProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor1);
        AttributeQueryDescriptorType aqDescriptor = (AttributeQueryDescriptorType)this.buildXMLObject(AttributeQueryDescriptorType.TYPE_NAME);
        aqDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        entityDescriptor.getRoleDescriptors().add(aqDescriptor);
        SPSSODescriptor spssoDescriptor2 = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spssoDescriptor2.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor2);
        return entityDescriptor;
    }
}

