/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.base.Function;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.impl.BasicDynamicTrustedNamesStrategy;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.w3c.dom.Element;

public class SignatureValidationFilterPKIXTest
extends XMLObjectBaseTestCase {
    private static final String DATA_PATH = "/org/opensaml/saml/metadata/resolver/filter/impl/";
    private SignatureValidationFilter filter;

    @BeforeMethod
    public void setUp() {
        this.filter = new SignatureValidationFilter(this.buildTrustEngine());
        this.filter.setDynamicTrustedNamesStrategy((Function)new BasicDynamicTrustedNamesStrategy());
    }

    @Test
    public void testEntityDescriptor() throws Exception {
        BasicX509Credential signingCredential = this.buildSigningCredential("entity.key", "entity.crt", "ca.crt");
        XMLObject entityDescriptor = this.generateSignedMetadata((Credential)signingCredential, "EntityDescriptor.xml");
        this.filter.filter(entityDescriptor);
    }

    @Test(expectedExceptions={FilterException.class})
    public void testEntityDescriptorInvalidEntityID() throws Exception {
        BasicX509Credential signingCredential = this.buildSigningCredential("entity.key", "entity.crt", "ca.crt");
        XMLObject entityDescriptor = this.generateSignedMetadata((Credential)signingCredential, "EntityDescriptor-invalid-entityid.xml");
        this.filter.filter(entityDescriptor);
    }

    private XMLObject generateSignedMetadata(Credential signingCredential, String unsignedMetadata) throws SecurityException, SignatureException, MarshallingException, UnmarshallingException {
        XMLObject unsignedObject = this.unmarshallElement(DATA_PATH + unsignedMetadata);
        if (!(unsignedObject instanceof SignableSAMLObject)) {
            Assert.fail((String)"Not a signable SAML object");
        }
        SignableSAMLObject signableSAML = (SignableSAMLObject)unsignedObject;
        SignatureSigningParameters params = new SignatureSigningParameters();
        params.setSigningCredential(signingCredential);
        params.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        params.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        params.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        X509KeyInfoGeneratorFactory kigf = new X509KeyInfoGeneratorFactory();
        kigf.setEmitEntityCertificate(true);
        kigf.setEmitEntityCertificateChain(true);
        kigf.setEmitX509SubjectName(true);
        params.setKeyInfoGenerator(kigf.newInstance());
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signableSAML.setSignature(signature);
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)params);
        Element dom = XMLObjectSupport.marshall((XMLObject)signableSAML);
        Signer.signObject((Signature)signature);
        return unmarshallerFactory.getUnmarshaller(dom).unmarshall(dom);
    }

    private SignatureTrustEngine buildTrustEngine() {
        Collection<X509Certificate> roots = this.getCertificates("root.crt");
        PKIXValidationInformation pkixInfo = this.getPKIXInfoSet(roots, new HashSet<X509CRL>(), 10);
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(Lists.newArrayList((Object[])new PKIXValidationInformation[]{pkixInfo}), new HashSet(), true);
        PKIXSignatureTrustEngine engine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)resolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver(), (PKIXTrustEvaluator)new CertPathPKIXTrustEvaluator(), (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator());
        return engine;
    }

    private PKIXValidationInformation getPKIXInfoSet(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth) {
        return new BasicPKIXValidationInformation(certs, crls, depth);
    }

    private BasicX509Credential buildSigningCredential(String key, String cert, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(cert);
        PrivateKey privateKey = this.getPrivateKey(key);
        BasicX509Credential cred = new BasicX509Credential(entityCert, privateKey);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred.setEntityCertificateChain(certChain);
        return cred;
    }

    private PrivateKey getPrivateKey(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return KeySupport.decodePrivateKey((byte[])encoded, null);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create private key from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private Collection<X509Certificate> getCertificates(String ... certNames) {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (String certName : certNames) {
            certs.add(this.getCertificate(certName));
        }
        return certs;
    }

    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private InputStream getInputStream(String fileName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(DATA_PATH + fileName);
    }
}

