/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SignatureValidationFilterExplicitKeyTest
extends XMLObjectBaseTestCase {
    private final String switchMDFileValid = "/org/opensaml/saml/saml2/metadata/provider/metadata.aaitest_signed.xml";
    private final String switchMDFileInvalid = "/org/opensaml/saml/saml2/metadata/provider/metadata.aaitest_signed.invalid.xml";
    private Document switchMDDocumentValid;
    private Document switchMDDocumentInvalid;
    private SignatureTrustEngine switchSigTrustEngine;
    private String switchMDCertBase64 = "MIICrzCCAhgCAQAwDQYJKoZIhvcNAQEEBQAwgZ8xCzAJBgNVBAYTAkNIMUAwPgYDVQQKEzdTV0lUQ0ggLSBUZWxlaW5mb3JtYXRpa2RpZW5zdGUgZnVlciBMZWhyZSB1bmQgRm9yc2NodW5nMQwwCgYDVQQLEwNBQUkxIjAgBgNVBAMTGVNXSVRDSGFhaSBNZXRhZGF0YSBTaWduZXIxHDAaBgkqhkiG9w0BCQEWDWFhaUBzd2l0Y2guY2gwHhcNMDUwODAzMTEyMjUxWhcNMTUwODAxMTEyMjUxWjCBnzELMAkGA1UEBhMCQ0gxQDA+BgNVBAoTN1NXSVRDSCAtIFRlbGVpbmZvcm1hdGlrZGllbnN0ZSBmdWVyIExlaHJlIHVuZCBGb3JzY2h1bmcxDDAKBgNVBAsTA0FBSTEiMCAGA1UEAxMZU1dJVENIYWFpIE1ldGFkYXRhIFNpZ25lcjEcMBoGCSqGSIb3DQEJARYNYWFpQHN3aXRjaC5jaDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAsmyBYNZ8mKYutdyQShzuOgnVxDP1UBZE+57S2ORZg1qi4JExOJEPnviHuh6HEajljhAMGHxr656paDpfXkmGq/Ybk3xmXy2FTnFGpjFpZUV6dY/oJ82rve27C/NVcwZw2nYRl5C5aCCgx/QlWsBTw+9972141+wBDH7dXlJ+UGkCAwEAATANBgkqhkiG9w0BAQQFAAOBgQCcLuNwTINkfhBlVCIuTixR1R6mYu/+4KUJWtHlRCOUZhSLFept8HxEvfwnuX9xm+Q6Ju/sOgmI1INuSstUGWwVy0AbpCphUDDmIh9A85ye8DrVaBHQrj5b/JEjCvkY0zhLJzgDzZ6btT40TuCnk2GpdAClu5SyCTiy56+zDYqPqg==";
    private final String openIDFileValid = "/org/opensaml/saml/saml2/metadata/provider/openid-metadata.xml";
    private final String openIDFileInvalid = "/org/opensaml/saml/saml2/metadata/provider/openid-metadata-invalid.xml";
    private String openIDCertBase64 = "MIICfTCCAeagAwIBAgIGAReueFpXMA0GCSqGSIb3DQEBBQUAMIGBMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFDASBgNVBAcTC1NpbWkgVmFsbGV5MR4wHAYDVQQKExVSYXBhdHRvbmkgQ29ycG9yYXRpb24xFDASBgNVBAsTC1NTTyBTdXBwb3J0MRkwFwYDVQQDExBtbHNzdGdzd21pY2hpZ2FuMB4XDTA4MDEyNTAxMDMxOFoXDTA5MDEyNDAxMDMxOFowgYExCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTEUMBIGA1UEBxMLU2ltaSBWYWxsZXkxHjAcBgNVBAoTFVJhcGF0dG9uaSBDb3Jwb3JhdGlvbjEUMBIGA1UECxMLU1NPIFN1cHBvcnQxGTAXBgNVBAMTEG1sc3N0Z3N3bWljaGlnYW4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIOnt2MOfIYvvyhiKBS2yb5IXFx+SFEa/TLSUPkE9gZJCIe22GGfiwzsC8ubpifebZUru1fespnaCE8rc7MtWXERW7x6Dp8wg/91NOgUB00eEUlA72DhDjelsYTJa+AzztBsWh6J3HFKNdNaSVTS+CqbmgdTlDW+BExbtHUfSP0RAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAYT8js8O7gbLq4X/yuGCiuKHofQHFAE6pAWaxdTD+Bd2pu48GKICYAhFwHTqrG3bOqObfsILz4PcavCfzIS7/dk9oPnjeH7GqbxUZMsms4qDZzdNkNDUDWj82lJzIMfZyUKbn2waTsgg3mKja0dGw2UByurPV4NvVcNaIQZJunHI=";
    private KeyInfoCredentialResolver kiResolver;

    @BeforeClass
    public void buildKeyInfoCredentialResolver() {
        this.kiResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.switchMDDocumentValid = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/metadata.aaitest_signed.xml"));
        this.switchMDDocumentInvalid = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/metadata.aaitest_signed.invalid.xml"));
        X509Certificate switchCert = X509Support.decodeCertificate((String)this.switchMDCertBase64);
        BasicX509Credential switchCred = CredentialSupport.getSimpleCredential((X509Certificate)switchCert, null);
        StaticCredentialResolver switchCredResolver = new StaticCredentialResolver((Credential)switchCred);
        this.switchSigTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)switchCredResolver, this.kiResolver);
    }

    @Test
    public void testValidSWITCHStandalone() throws UnmarshallingException {
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(this.switchMDDocumentValid.getDocumentElement()).unmarshall(this.switchMDDocumentValid.getDocumentElement());
        SignatureValidationFilter filter = new SignatureValidationFilter(this.switchSigTrustEngine);
        try {
            filter.filter(xmlObject);
        }
        catch (FilterException e) {
            Assert.fail((String)("Filter failed validation, should have succeeded: " + e.getMessage()));
        }
    }

    @Test(expectedExceptions={FilterException.class})
    public void testSWITCHStandaloneBlacklistedSignatureAlgorithm() throws UnmarshallingException, FilterException {
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(this.switchMDDocumentValid.getDocumentElement()).unmarshall(this.switchMDDocumentValid.getDocumentElement());
        SignatureValidationFilter filter = new SignatureValidationFilter(this.switchSigTrustEngine);
        SignatureValidationParameters sigParams = new SignatureValidationParameters();
        sigParams.setBlacklistedAlgorithms(Collections.singleton("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        CriteriaSet defaultCriteriaSet = new CriteriaSet(new Criterion[]{new SignatureValidationParametersCriterion(sigParams)});
        filter.setDefaultCriteria(defaultCriteriaSet);
        filter.filter(xmlObject);
    }

    @Test
    public void testInvalidSWITCHStandalone() throws UnmarshallingException {
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(this.switchMDDocumentInvalid.getDocumentElement()).unmarshall(this.switchMDDocumentInvalid.getDocumentElement());
        SignatureValidationFilter filter = new SignatureValidationFilter(this.switchSigTrustEngine);
        try {
            filter.filter(xmlObject);
            Assert.fail((String)"Filter passed validation, should have failed");
        }
        catch (FilterException filterException) {
            // empty catch block
        }
    }

    @Test
    public void testEntityDescriptor() throws UnmarshallingException, CertificateException, XMLParserException {
        X509Certificate cert = X509Support.decodeCertificate((String)this.openIDCertBase64);
        BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)cert, null);
        StaticCredentialResolver credResolver = new StaticCredentialResolver((Credential)cred);
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, this.kiResolver);
        Document mdDoc = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/openid-metadata.xml"));
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(mdDoc.getDocumentElement()).unmarshall(mdDoc.getDocumentElement());
        Assert.assertTrue((boolean)(xmlObject instanceof EntityDescriptor));
        EntityDescriptor ed = (EntityDescriptor)xmlObject;
        Assert.assertTrue((boolean)ed.isSigned());
        Assert.assertNotNull((Object)ed.getSignature(), (String)"Signature was null");
        SignatureValidationFilter filter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        try {
            filter.filter((XMLObject)ed);
        }
        catch (FilterException e) {
            Assert.fail((String)("Filter failed validation, should have succeeded: " + e.getMessage()));
        }
    }

    @Test
    public void testEntityDescriptorInvalid() throws UnmarshallingException, CertificateException, XMLParserException {
        X509Certificate cert = X509Support.decodeCertificate((String)this.openIDCertBase64);
        BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)cert, null);
        StaticCredentialResolver credResolver = new StaticCredentialResolver((Credential)cred);
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, this.kiResolver);
        Document mdDoc = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/openid-metadata-invalid.xml"));
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(mdDoc.getDocumentElement()).unmarshall(mdDoc.getDocumentElement());
        Assert.assertTrue((boolean)(xmlObject instanceof EntityDescriptor));
        EntityDescriptor ed = (EntityDescriptor)xmlObject;
        Assert.assertTrue((boolean)ed.isSigned());
        Assert.assertNotNull((Object)ed.getSignature(), (String)"Signature was null");
        SignatureValidationFilter filter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        try {
            filter.filter(xmlObject);
            Assert.fail((String)"Filter passed validation, should have failed");
        }
        catch (FilterException filterException) {
            // empty catch block
        }
    }

    @Test
    public void testEntityDescriptorWithProvider() throws CertificateException, XMLParserException, UnmarshallingException {
        X509Certificate cert = X509Support.decodeCertificate((String)this.openIDCertBase64);
        BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)cert, null);
        StaticCredentialResolver credResolver = new StaticCredentialResolver((Credential)cred);
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, this.kiResolver);
        Document mdDoc = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/openid-metadata.xml"));
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(mdDoc.getDocumentElement());
        mdProvider.setParserPool(parserPool);
        mdProvider.setId("test");
        mdProvider.setRequireValidMetadata(false);
        SignatureValidationFilter filter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        mdProvider.setMetadataFilter((MetadataFilter)filter);
        try {
            mdProvider.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Failed when initializing metadata provider");
        }
    }

    @Test
    public void testInvalidEntityDescriptorWithProvider() throws CertificateException, XMLParserException, UnmarshallingException {
        X509Certificate cert = X509Support.decodeCertificate((String)this.openIDCertBase64);
        BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)cert, null);
        StaticCredentialResolver credResolver = new StaticCredentialResolver((Credential)cred);
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, this.kiResolver);
        Document mdDoc = parserPool.parse(SignatureValidationFilterExplicitKeyTest.class.getResourceAsStream("/org/opensaml/saml/saml2/metadata/provider/openid-metadata-invalid.xml"));
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(mdDoc.getDocumentElement());
        mdProvider.setParserPool(parserPool);
        mdProvider.setRequireValidMetadata(false);
        SignatureValidationFilter filter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        mdProvider.setId("test");
        mdProvider.setMetadataFilter((MetadataFilter)filter);
        try {
            mdProvider.initialize();
            Assert.fail((String)"Metadata signature was invalid, provider initialization should have failed");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }
}

