/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.base.Predicate;
import java.util.Collections;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.common.profile.logic.EntityIdPredicate;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PredicateFilterTest
extends XMLObjectBaseTestCase {
    private ResourceBackedMetadataResolver metadataProvider;
    private ResourceBackedMetadataResolver singleEntityProvider;

    @BeforeMethod
    protected void setUp() throws Exception {
        ClassPathResource resource = new ClassPathResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.metadataProvider = new ResourceBackedMetadataResolver(null, ResourceHelper.of((Resource)resource));
        this.metadataProvider.setId("multi");
        this.metadataProvider.setParserPool(parserPool);
        ClassPathResource singleResource = new ClassPathResource("/org/opensaml/saml/saml2/metadata/entitydescriptor-metadata.xml");
        this.singleEntityProvider = new ResourceBackedMetadataResolver(null, ResourceHelper.of((Resource)singleResource));
        this.singleEntityProvider.setId("single");
        this.singleEntityProvider.setParserPool(parserPool);
    }

    @Test
    public void testBlacklist() throws Exception {
        String whitelisted = "urn:mace:incommon:dartmouth.edu";
        String blacklisted = "urn:mace:incommon:osu.edu";
        String osu = "urn:mace:incommon:osu.edu";
        EntityIdPredicate condition = new EntityIdPredicate(Collections.singletonList("urn:mace:incommon:osu.edu"));
        this.metadataProvider.setMetadataFilter((MetadataFilter)new PredicateFilter(PredicateFilter.Direction.EXCLUDE, (Predicate)condition));
        this.metadataProvider.initialize();
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:osu.edu")}));
        Assert.assertNull((Object)entity);
        entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:dartmouth.edu")}));
        Assert.assertNotNull((Object)entity);
        this.singleEntityProvider.setMetadataFilter((MetadataFilter)new PredicateFilter(PredicateFilter.Direction.EXCLUDE, (Predicate)condition));
        this.singleEntityProvider.initialize();
        entity = this.singleEntityProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:osu.edu")}));
        Assert.assertNull((Object)entity);
    }

    @Test
    public void testWhitelist() throws Exception {
        String whitelisted = "urn:mace:incommon:dartmouth.edu";
        String blacklisted = "urn:mace:incommon:osu.edu";
        String osu = "urn:mace:incommon:osu.edu";
        EntityIdPredicate condition = new EntityIdPredicate(Collections.singletonList("urn:mace:incommon:dartmouth.edu"));
        this.metadataProvider.setMetadataFilter((MetadataFilter)new PredicateFilter(PredicateFilter.Direction.INCLUDE, (Predicate)condition));
        this.metadataProvider.initialize();
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:osu.edu")}));
        Assert.assertNull((Object)entity);
        entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:dartmouth.edu")}));
        Assert.assertNotNull((Object)entity);
        this.singleEntityProvider.setMetadataFilter((MetadataFilter)new PredicateFilter(PredicateFilter.Direction.INCLUDE, (Predicate)new EntityIdPredicate(Collections.singletonList("urn:mace:incommon:osu.edu"))));
        this.singleEntityProvider.initialize();
        entity = this.singleEntityProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:mace:incommon:osu.edu")}));
        Assert.assertNotNull((Object)entity);
    }
}

