/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NodeProcessingMetadataFilterTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private NodeProcessingMetadataFilter metadataFilter;
    private ArrayList<MetadataNodeProcessor> processors;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataFilter = new NodeProcessingMetadataFilter();
        this.processors = new ArrayList();
    }

    @Test
    public void testBasicVisit() throws ComponentInitializationException {
        MetadataNodeProcessor processor = new MetadataNodeProcessor(){

            public void process(XMLObject metadataNode) throws FilterException {
                if (metadataNode instanceof EntityDescriptor) {
                    metadataNode.getObjectMetadata().put((Object)new TestData("EntityDescriptor"));
                } else if (metadataNode instanceof RoleDescriptor) {
                    metadataNode.getObjectMetadata().put((Object)new TestData("RoleDescriptor"));
                } else if (metadataNode instanceof KeyDescriptor) {
                    metadataNode.getObjectMetadata().put((Object)new TestData("KeyDescriptor"));
                }
            }
        };
        this.processors.add(processor);
        this.metadataFilter.setNodeProcessors(this.processors);
        this.metadataFilter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.metadataFilter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        for (EntityDescriptor ed : this.metadataProvider) {
            this.checkNode((XMLObject)ed);
        }
    }

    private void checkNode(XMLObject node) {
        List objectTestData = node.getObjectMetadata().get(TestData.class);
        if (node instanceof EntityDescriptor) {
            Assert.assertEquals((int)objectTestData.size(), (int)1);
            Assert.assertEquals((String)((TestData)objectTestData.get(0)).getData(), (String)"EntityDescriptor");
        } else if (node instanceof RoleDescriptor) {
            Assert.assertEquals((int)objectTestData.size(), (int)1);
            Assert.assertEquals((String)((TestData)objectTestData.get(0)).getData(), (String)"RoleDescriptor");
        } else if (node instanceof KeyDescriptor) {
            Assert.assertEquals((int)objectTestData.size(), (int)1);
            Assert.assertEquals((String)((TestData)objectTestData.get(0)).getData(), (String)"KeyDescriptor");
        } else {
            Assert.assertEquals((int)0, (int)objectTestData.size());
        }
        List children = node.getOrderedChildren();
        if (children != null) {
            for (XMLObject child : children) {
                if (child == null) continue;
                this.checkNode(child);
            }
        }
    }

    public class TestData {
        private String data;

        public TestData(String newData) {
            this.data = newData;
        }

        public String getData() {
            return this.data;
        }
    }
}

