/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import org.apache.http.client.HttpClient;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityRoleFilter;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntityRoleFilterTest
extends XMLObjectBaseTestCase {
    private HttpClient httpClient;
    private HttpClientBuilder httpClientBuilder;
    private HTTPMetadataResolver metadataProvider;
    private HttpClientSecurityParameters httpClientParams;
    private String inCommonMDURL;

    @BeforeClass
    protected void setUpClass() throws Exception {
        this.httpClientBuilder = new HttpClientBuilder();
        this.httpClientBuilder.setConnectionTimeout(5000L);
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.httpClient = this.httpClientBuilder.buildClient();
        this.httpClientParams = new HttpClientSecurityParameters();
        this.httpClientParams.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.inCommonMDURL = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
    }

    @BeforeMethod
    protected void setUpMethod() throws Exception {
        this.metadataProvider = new HTTPMetadataResolver(this.httpClient, this.inCommonMDURL);
        this.metadataProvider.setHttpClientSecurityParameters(this.httpClientParams);
    }

    @Test
    public void testWhiteListSPRole() throws Exception {
        ArrayList<QName> retainedRoles = new ArrayList<QName>();
        retainedRoles.add(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)new EntityRoleFilter(retainedRoles));
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
    }

    @Test
    public void testWhiteListIdPRoles() throws Exception {
        ArrayList<QName> retainedRoles = new ArrayList<QName>();
        retainedRoles.add(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        retainedRoles.add(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)new EntityRoleFilter(retainedRoles));
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
    }

    @Test
    public void testWhiteListNoRole() throws Exception {
        ArrayList retainedRoles = new ArrayList();
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)new EntityRoleFilter(retainedRoles));
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
    }
}

