/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.base.Predicate;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityAttributesFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntityAttributesFilterTest
extends XMLObjectBaseTestCase
implements Predicate<EntityDescriptor> {
    private SAMLObjectBuilder<Attribute> tagBuilder;
    private XMLObjectBuilder<XSString> valueBuilder;
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.tagBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.DEFAULT_ELEMENT_NAME);
        this.valueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
    }

    @Test
    public void test() throws ComponentInitializationException, ResolverException {
        Attribute tag = (Attribute)this.tagBuilder.buildObject();
        tag.setName("foo");
        XSString value = (XSString)this.valueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        value.setValue("bar");
        tag.getAttributeValues().add(value);
        List<Attribute> tags = Collections.singletonList(tag);
        EntityAttributesFilter filter = new EntityAttributesFilter();
        filter.setRules(Collections.singletonMap(this, tags));
        filter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)filter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityIdCriterion key = new EntityIdCriterion("https://carmenwiki.osu.edu/shibboleth");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Extensions exts = entity.getExtensions();
        Assert.assertNotNull((Object)exts);
        List extElements = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        Assert.assertFalse((boolean)extElements.isEmpty());
        EntityAttributes extTags = (EntityAttributes)extElements.iterator().next();
        Assert.assertNotNull((Object)extTags);
        Assert.assertEquals((int)extTags.getAttributes().size(), (int)2);
        Assert.assertEquals((String)((Attribute)extTags.getAttributes().get(0)).getName(), (String)"http://macedir.org/entity-category");
        Assert.assertEquals((String)((Attribute)extTags.getAttributes().get(1)).getName(), (String)"foo");
        key = new EntityIdCriterion("https://cms.psu.edu/Shibboleth");
        entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        exts = entity.getExtensions();
        Assert.assertNull((Object)exts);
    }

    @Test
    public void testWithWhitelist() throws ComponentInitializationException, ResolverException {
        Attribute tag = (Attribute)this.tagBuilder.buildObject();
        tag.setName("foo");
        XSString value = (XSString)this.valueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        value.setValue("bar");
        tag.getAttributeValues().add(value);
        List<Attribute> tags = Collections.singletonList(tag);
        EntityAttributesFilter filter = new EntityAttributesFilter();
        filter.setRules(Collections.singletonMap(this, tags));
        filter.setAttributeFilter((Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute input) {
                return "foo".equals(input.getName());
            }
        });
        filter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)filter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityIdCriterion key = new EntityIdCriterion("https://carmenwiki.osu.edu/shibboleth");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Extensions exts = entity.getExtensions();
        Assert.assertNotNull((Object)exts);
        List extElements = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        Assert.assertFalse((boolean)extElements.isEmpty());
        EntityAttributes extTags = (EntityAttributes)extElements.iterator().next();
        Assert.assertNotNull((Object)extTags);
        Assert.assertEquals((int)extTags.getAttributes().size(), (int)1);
        Assert.assertEquals((String)((Attribute)extTags.getAttributes().get(0)).getName(), (String)"foo");
    }

    public boolean apply(EntityDescriptor input) {
        return input.getEntityID().equals("https://carmenwiki.osu.edu/shibboleth");
    }
}

