/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.samlec.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.samlec.EncType;
import org.opensaml.saml.ext.samlec.SessionKey;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SessionKeyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlg;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public SessionKeyTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/samlec/impl/SessionKey.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/samlec/impl/SessionKeyChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlg = "http://myalgorithm.example.com";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SessionKey key = (SessionKey)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)key.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)key.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
        Assert.assertEquals((String)this.expectedAlg, (String)key.getAlgorithm(), (String)"Algorithm had unexpected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        SessionKey key = (SessionKey)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)key.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)key.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
        Assert.assertEquals((int)2, (int)key.getEncTypes().size(), (String)"Wrong number of EncTypes");
    }

    @Test
    public void testSingleElementMarshall() {
        SessionKey key = (SessionKey)this.buildXMLObject(SessionKey.DEFAULT_ELEMENT_NAME);
        key.setSOAP11Actor(this.expectedSOAP11Actor);
        key.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        key.setAlgorithm(this.expectedAlg);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)key);
    }

    @Test
    public void testChildElementsMarshall() {
        SessionKey key = (SessionKey)this.buildXMLObject(SessionKey.DEFAULT_ELEMENT_NAME);
        key.setSOAP11Actor(this.expectedSOAP11Actor);
        key.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        key.getEncTypes().add((EncType)this.buildXMLObject(EncType.DEFAULT_ELEMENT_NAME));
        key.getEncTypes().add((EncType)this.buildXMLObject(EncType.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)key);
    }
}

