/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LogoTest
extends XMLObjectProviderBaseTestCase {
    private final String expectedURL;
    private final String expectedLang;
    private final Integer expectedHeight;
    private final Integer expectedWidth;

    public LogoTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdui/Logo.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2mdui/LogoWithLang.xml";
        this.expectedURL = "http://exaple.org/Logo";
        this.expectedHeight = new Integer(10);
        this.expectedWidth = new Integer(23);
        this.expectedLang = "logoLang";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Logo logo = (Logo)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)logo.getURL(), (String)this.expectedURL, (String)"URL was not expected value");
        Assert.assertEquals((Object)logo.getHeight(), (Object)this.expectedHeight, (String)"height was not expected value");
        Assert.assertEquals((Object)logo.getWidth(), (Object)this.expectedWidth, (String)"width was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Logo logo = (Logo)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)logo.getURL(), (String)this.expectedURL, (String)"URL was not expected value");
        Assert.assertEquals((Object)logo.getHeight(), (Object)this.expectedHeight, (String)"height was not expected value");
        Assert.assertEquals((Object)logo.getWidth(), (Object)this.expectedWidth, (String)"width was not expected value");
        Assert.assertEquals((String)logo.getXMLLang(), (String)this.expectedLang, (String)"xml:lang was not the expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        Logo logo = (Logo)this.buildXMLObject(Logo.DEFAULT_ELEMENT_NAME);
        logo.setURL(this.expectedURL);
        logo.setWidth(this.expectedWidth);
        logo.setHeight(this.expectedHeight);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)logo);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Logo logo = (Logo)this.buildXMLObject(Logo.DEFAULT_ELEMENT_NAME);
        logo.setURL(this.expectedURL);
        logo.setWidth(this.expectedWidth);
        logo.setHeight(this.expectedHeight);
        logo.setXMLLang(this.expectedLang);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)logo);
    }
}

