/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeywordsTest
extends XMLObjectProviderBaseTestCase {
    private final List<String> expectedWords;
    private final String expectedLang;

    public KeywordsTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdui/Keywords.xml";
        String[] contents = new String[]{"This", "is", "a", "six", "element", "keyword"};
        this.expectedWords = new ArrayList<String>(contents.length);
        for (String s : contents) {
            this.expectedWords.add(s);
        }
        this.expectedLang = "en";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Keywords name = (Keywords)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Collection)name.getKeywords(), this.expectedWords, (String)"Keyworks were not expected value");
        Assert.assertEquals((String)name.getXMLLang(), (String)this.expectedLang, (String)"Language was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        Keywords keywords = (Keywords)this.buildXMLObject(Keywords.DEFAULT_ELEMENT_NAME);
        keywords.setXMLLang(this.expectedLang);
        keywords.setKeywords(this.expectedWords);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keywords);
    }
}

