/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdrpi.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.saml2mdrpi.Publication;
import org.testng.Assert;

public class PublicationTest
extends XMLObjectProviderBaseTestCase {
    private static String expectedPublisher = "publisher";
    private static String expectedPublicationId = "Ident";
    private static DateTime expectedCreationInstant = new DateTime(2010, 8, 11, 14, 59, 1, 2, (Chronology)ISOChronology.getInstanceUTC());

    public PublicationTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdrpi/Publication.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationOptionalAttr.xml";
    }

    public void testSingleElementUnmarshall() {
        Publication info = (Publication)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        Publication info = (Publication)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
        Assert.assertEquals((String)info.getPublicationId(), (String)expectedPublicationId);
        Assert.assertEquals((Object)info.getCreationInstant(), (Object)expectedCreationInstant);
    }

    public void testSingleElementMarshall() {
        Publication info = (Publication)this.buildXMLObject(Publication.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)info);
    }

    public void testSingleElementOptionalAttributesMarshall() {
        Publication info = (Publication)this.buildXMLObject(Publication.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        info.setCreationInstant(expectedCreationInstant);
        info.setPublicationId(expectedPublicationId);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)info);
    }
}

