/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdattr.impl;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EntityAttributesTest
extends XMLObjectProviderBaseTestCase {
    public EntityAttributesTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdattr/EntityAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdattr/EntityAttributesChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EntityAttributes attributes = (EntityAttributes)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)attributes);
        Assert.assertTrue((boolean)attributes.getAssertions().isEmpty());
        Assert.assertTrue((boolean)attributes.getAttributes().isEmpty());
    }

    @Test
    public void testChildElementsUnmarshall() {
        EntityAttributes attributes = (EntityAttributes)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((int)attributes.getAssertions().size(), (int)2);
        Assert.assertEquals((int)attributes.getAttributes().size(), (int)3);
    }

    @Test
    public void testSingleElementMarshall() {
        EntityAttributes attributes = (EntityAttributes)this.buildXMLObject(EntityAttributes.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributes);
    }

    @Test
    public void testChildElementsMarshall() {
        Assertion assertion1 = (Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion1.setIssueInstant(new DateTime(1984, 8, 26, 10, 1, 30, 0, DateTimeZone.UTC));
        Assertion assertion2 = (Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion2.setIssueInstant(new DateTime(1984, 8, 26, 10, 1, 30, 0, DateTimeZone.UTC));
        Attribute attrib1 = (Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        attrib1.setName("attrib1");
        Attribute attrib2 = (Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        attrib2.setName("attrib2");
        Attribute attrib3 = (Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        attrib3.setName("attrib3");
        EntityAttributes attributes = (EntityAttributes)this.buildXMLObject(EntityAttributes.DEFAULT_ELEMENT_NAME);
        attributes.getAssertions().add(assertion1);
        attributes.getAttributes().add(attrib1);
        attributes.getAssertions().add(assertion2);
        attributes.getAttributes().add(attrib2);
        attributes.getAttributes().add(attrib3);
        Assert.assertEquals((int)attributes.getOrderedChildren().size(), (int)5);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributes);
    }
}

