/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import com.google.common.base.Function;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.impl.AddNotOnOrAfterConditionToAssertions;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddNotOnOrAfterConditionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private AddNotOnOrAfterConditionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action = new AddNotOnOrAfterConditionToAssertions();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        this.prc.setOutboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testSingleAssertion() {
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(assertion);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getNotOnOrAfter());
        Assert.assertEquals((long)assertion.getConditions().getNotOnOrAfter().minus(response.getIssueInstant().getMillis()).getMillis(), (long)300000L);
    }

    @Test
    public void testSingleAssertionWithExistingConditions() throws ComponentInitializationException {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(assertion);
        AddNotOnOrAfterConditionToAssertions action = new AddNotOnOrAfterConditionToAssertions();
        action.setDefaultAssertionLifetime(600000L);
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertSame((Object)assertion.getConditions(), (Object)conditions);
        Assert.assertNotNull((Object)assertion.getConditions().getNotOnOrAfter());
        Assert.assertEquals((long)assertion.getConditions().getNotOnOrAfter().minus(response.getIssueInstant().getMillis()).getMillis(), (long)600000L);
    }

    @Test
    public void testMultipleAssertion() throws ComponentInitializationException {
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        AddNotOnOrAfterConditionToAssertions action = new AddNotOnOrAfterConditionToAssertions();
        action.setAssertionLifetimeStrategy((Function)new Function<ProfileRequestContext, Long>(){

            public Long apply(ProfileRequestContext input) {
                return 180000L;
            }
        });
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getNotOnOrAfter());
            Assert.assertEquals((long)assertion.getConditions().getNotOnOrAfter().minus(response.getIssueInstant().getMillis()).getMillis(), (long)180000L);
        }
    }

    @Test
    public void testSAML2Assertion() {
        org.opensaml.saml.saml2.core.Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        org.opensaml.saml.saml2.core.Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getNotOnOrAfter());
        Assert.assertEquals((long)assertion.getConditions().getNotOnOrAfter().minus(response.getIssueInstant().getMillis()).getMillis(), (long)300000L);
    }
}

