/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLOutboundProtocolMessageSigningHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext<SAMLObject> messageContext;
    private SAMLOutboundProtocolMessageSigningHandler handler;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, NoSuchProviderException, ComponentInitializationException {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        BasicCredential cred = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential((Credential)cred);
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingParameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        this.messageContext = new MessageContext();
        ((SecurityParametersContext)this.messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
        this.handler = new SAMLOutboundProtocolMessageSigningHandler();
        this.handler.setSignErrorResponses(false);
        this.handler.initialize();
    }

    @Test
    public void testSAML2Response() throws MessageHandlerException {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setID("abc123");
        response.setIssueInstant(new DateTime());
        Issuer issuer = (Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue("http://idp.example.org");
        response.setIssuer(issuer);
        StatusCode sc = (StatusCode)this.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        sc.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        Status status = (Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        status.setStatusCode(sc);
        response.setStatus(status);
        this.messageContext.setMessage((Object)response);
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)response.getSignature(), (String)"Signature was null");
    }

    @Test
    public void testSAML2ErrorResponse() throws MessageHandlerException {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setID("abc123");
        response.setIssueInstant(new DateTime());
        Issuer issuer = (Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue("http://idp.example.org");
        response.setIssuer(issuer);
        StatusCode sc = (StatusCode)this.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        sc.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        Status status = (Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        status.setStatusCode(sc);
        response.setStatus(status);
        this.messageContext.setMessage((Object)response);
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)response.getSignature(), (String)"Signature was not null");
    }
}

