/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageLifetimeSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext<SAMLObject> messageContext;
    private MessageLifetimeSecurityHandler handler;
    private long clockSkew;
    private long messageLifetime;
    private DateTime now;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.now = new DateTime(DateTimeZone.UTC);
        this.clockSkew = 300000L;
        this.messageLifetime = 600000L;
        this.messageContext = new MessageContext();
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now);
        this.handler = new MessageLifetimeSecurityHandler();
        this.handler.setClockSkew(this.clockSkew);
        this.handler.setMessageLifetime(this.messageLifetime);
        this.handler.initialize();
    }

    @Test
    public void testValid() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidIssuedInFuture() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.plus(this.clockSkew + 5000L));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testValidIssuedInFutureWithinClockSkew() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.plus(this.clockSkew - 5000L));
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidExpired() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.minus(this.messageLifetime + (this.clockSkew + 5000L)));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testValidExpiredWithinClockSkew() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.minus(this.messageLifetime + (this.clockSkew - 5000L)));
        this.handler.invoke(this.messageContext);
    }
}

