/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import com.google.common.base.Function;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLAddAttributeConsumingServiceHandler;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAMLAddAttributeConsumingServiceHandleTest
extends XMLObjectBaseTestCase {
    private SPSSODescriptor withACS;
    private SPSSODescriptor noACS;

    private SAMLMetadataContext getMetadataContext(MessageContext<SAMLObject> message) {
        return (SAMLMetadataContext)((SAMLPeerEntityContext)message.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLMetadataContext.class, true);
    }

    private SAMLAddAttributeConsumingServiceHandler handler() throws ComponentInitializationException {
        SAMLAddAttributeConsumingServiceHandler h = new SAMLAddAttributeConsumingServiceHandler();
        h.initialize();
        return h;
    }

    @BeforeClass
    public void classSetUp() throws ComponentInitializationException {
        this.withACS = (SPSSODescriptor)this.unmarshallElement("/org/opensaml/saml/common/binding/SPSSOwithACS.xml");
        this.noACS = (SPSSODescriptor)this.unmarshallElement("/org/opensaml/saml/common/binding/SPSSOnoACS.xml");
    }

    @Test
    public void noMetadataDataContext() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        this.handler().invoke(messageContext);
    }

    @Test
    public void noSPSSODesc() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        this.handler().invoke(messageContext);
        Assert.assertNull((Object)metadataContext.getSubcontext(AttributeConsumingServiceContext.class));
    }

    @Test
    public void authnNoIndex() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.withACS);
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        messageContext.setMessage((Object)request);
        this.handler().invoke(messageContext);
        AttributeConsumingService acs = ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class)).getAttributeConsumingService();
        Assert.assertTrue((boolean)acs.isDefault());
        Assert.assertEquals((int)acs.getIndex(), (int)3);
    }

    @Test
    public void authnWithIndex() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.withACS);
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        request.setAttributeConsumingServiceIndex(new Integer(1));
        messageContext.setMessage((Object)request);
        this.handler().invoke(messageContext);
        AttributeConsumingService acs = ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class)).getAttributeConsumingService();
        Assert.assertFalse((boolean)acs.isDefault());
        Assert.assertEquals((int)acs.getIndex(), (int)1);
    }

    @Test
    public void authnBadIndex() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.withACS);
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        request.setAttributeConsumingServiceIndex(new Integer(9));
        messageContext.setMessage((Object)request);
        this.handler().invoke(messageContext);
        AttributeConsumingService acs = ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class)).getAttributeConsumingService();
        Assert.assertTrue((boolean)acs.isDefault());
        Assert.assertEquals((int)acs.getIndex(), (int)3);
    }

    @Test
    public void authnNoACS() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.noACS);
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        messageContext.setMessage((Object)request);
        this.handler().invoke(messageContext);
        Assert.assertNull((Object)metadataContext.getSubcontext(AttributeConsumingServiceContext.class));
    }

    @Test
    public void noAuthn() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageContext = new MessageContext();
        SAMLMetadataContext metadataContext = this.getMetadataContext((MessageContext<SAMLObject>)messageContext);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.withACS);
        AuthenticationStatement request = SAML1ActionTestingSupport.buildAuthenticationStatement();
        messageContext.setMessage((Object)request);
        this.handler().invoke(messageContext);
        AttributeConsumingService acs = ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class)).getAttributeConsumingService();
        Assert.assertTrue((boolean)acs.isDefault());
        Assert.assertEquals((int)acs.getIndex(), (int)3);
    }

    @Test
    public void navigate() throws MessageHandlerException, ComponentInitializationException {
        SAMLAddAttributeConsumingServiceHandler navigatedHandler = new SAMLAddAttributeConsumingServiceHandler();
        navigatedHandler.setMetadataContextLookupStrategy((Function)new ParentContextLookup());
        SAMLMetadataContext metadataContext = new SAMLMetadataContext();
        MessageContext messageContext = (MessageContext)metadataContext.getSubcontext(MessageContext.class, true);
        metadataContext.setRoleDescriptor((RoleDescriptor)this.withACS);
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        request.setAttributeConsumingServiceIndex(new Integer(1));
        navigatedHandler.initialize();
        messageContext.setMessage((Object)request);
        navigatedHandler.invoke(messageContext);
        AttributeConsumingService acs = ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class)).getAttributeConsumingService();
        Assert.assertFalse((boolean)acs.isDefault());
        Assert.assertEquals((int)acs.getIndex(), (int)1);
    }
}

