/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact.impl;

import java.io.IOException;
import net.shibboleth.utilities.java.support.xml.XMLAssertTestNG;
import org.custommonkey.xmlunit.Diff;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.StorageServiceSAMLArtifactMap;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class StorageServiceSAMLArtifactMapTest
extends XMLObjectBaseTestCase {
    private MemoryStorageService storageService;
    private StorageServiceSAMLArtifactMap artifactMap;
    private String artifact = "the-artifact";
    private String issuerId = "urn:test:issuer";
    private String rpId = "urn:test:rp";
    private long lifetime = 300000L;
    private SAMLObject samlObject;
    private Document origDocument;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.samlObject = (SAMLObject)this.unmarshallElement("/org/opensaml/saml/saml2/core/ResponseSuccessAuthnAttrib.xml");
        this.origDocument = this.samlObject.getDOM().getOwnerDocument();
        this.samlObject.releaseChildrenDOM(true);
        this.samlObject.releaseDOM();
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.initialize();
        this.artifactMap = new StorageServiceSAMLArtifactMap();
        this.artifactMap.setStorageService((StorageService)this.storageService);
        this.artifactMap.setArtifactLifetime(this.lifetime);
        this.artifactMap.initialize();
    }

    @Test
    public void testBasicPutGet() throws IOException, MarshallingException {
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((String)entry.getArtifact(), (String)this.artifact, (String)"Invalid value for artifact");
        Assert.assertEquals((String)entry.getIssuerId(), (String)this.issuerId, (String)"Invalid value for issuer ID");
        Assert.assertEquals((String)entry.getRelyingPartyId(), (String)this.rpId, (String)"Invalid value for relying party ID");
        SAMLObject retrievedObject = entry.getSamlMessage();
        Document newDocument = marshallerFactory.getMarshaller((XMLObject)retrievedObject).marshall((XMLObject)retrievedObject).getOwnerDocument();
        XMLAssertTestNG.assertXMLIdentical((Diff)new Diff(this.origDocument, newDocument), (boolean)true);
    }

    @Test
    public void testRemove() throws IOException {
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.remove(this.artifact);
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNull((Object)entry, (String)"Entry was removed");
    }

    @Test
    public void testEntryExpiration() throws Exception {
        this.artifactMap = new StorageServiceSAMLArtifactMap();
        this.artifactMap.setStorageService((StorageService)this.storageService);
        this.artifactMap.setArtifactLifetime(1000L);
        this.artifactMap.initialize();
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        Thread.sleep(3000L);
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNull((Object)entry, (String)"Entry should have expired");
    }
}

