/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class RegexRequestURLBuilder
implements Function<String, String> {
    private String pattern;
    private String template;

    public RegexRequestURLBuilder(@Nonnull @NotEmpty String regex, @Nonnull @NotEmpty String replacement) {
        this.pattern = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)regex), (String)"Regex was null or empty");
        this.template = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)replacement), (String)"Replacement template was null or empty");
    }

    @Nullable
    public String apply(@Nonnull String entityID) {
        Constraint.isNotNull((Object)entityID, (String)"Entity ID was null");
        return entityID.replaceAll(this.pattern, this.template);
    }
}

